/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.m2repo.impl.scanner;

import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.Coordinates;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.MavenArtifactHelper;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenArtifactIdDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenGroupIdDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenRepositoryDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenVersionDescriptor;
import com.buschmais.xo.api.ResultIterator;
import java.util.function.Consumer;
import java.util.function.Predicate;

class GAVResolver {
    private final Store store;
    private final MavenRepositoryDescriptor repositoryDescriptor;
    private final String CACHE_KEY_GROUP_ID = GAVResolver.class.getName() + "_GROUP_ID";
    private final String CACHE_KEY_ARTIFACT_ID = GAVResolver.class.getName() + "_ARTIFACT_ID";
    private final String CACHE_KEY_VERSION = GAVResolver.class.getName() + "VERSION";

    GAVResolver(Store store, MavenRepositoryDescriptor repositoryDescriptor) {
        this.store = store;
        this.repositoryDescriptor = repositoryDescriptor;
    }

    public MavenVersionDescriptor resolve(Coordinates coordinates) {
        String baseVersion = MavenArtifactHelper.getBaseVersion((Coordinates)coordinates);
        GAV gav = GAV.builder().groupId(coordinates.getGroup()).artifactId(coordinates.getName()).version(baseVersion).build();
        return (MavenVersionDescriptor)this.store.getCache(this.CACHE_KEY_VERSION).get((Object)gav, key -> {
            GAV ga = GAV.builder().groupId(coordinates.getGroup()).artifactId(coordinates.getName()).build();
            String versionFQN = coordinates.getGroup() + ":" + coordinates.getName() + ":" + baseVersion;
            return this.getVersion((MavenArtifactIdDescriptor)this.store.getCache(this.CACHE_KEY_ARTIFACT_ID).get((Object)ga, gaKey -> {
                String artifactFQN = coordinates.getGroup() + ":" + coordinates.getName();
                return this.getArtifactId((MavenGroupIdDescriptor)this.store.getCache(this.CACHE_KEY_GROUP_ID).get((Object)coordinates.getGroup(), groupId -> this.getGroupId((String)groupId)), artifactFQN, coordinates.getName());
            }), versionFQN, baseVersion);
        });
    }

    private MavenGroupIdDescriptor getGroupId(String groupId) {
        return this.getOrCreate(MavenGroupIdDescriptor.class, groupId, g -> this.repositoryDescriptor.equals(g.getRepository()), g -> {
            g.setName(groupId);
            g.setRepository(this.repositoryDescriptor);
        });
    }

    private MavenArtifactIdDescriptor getArtifactId(MavenGroupIdDescriptor groupId, String fqn, String name) {
        return this.getOrCreate(MavenArtifactIdDescriptor.class, fqn, a -> groupId.equals(a.getGroupId()), a -> {
            a.setFullQualifiedName(fqn);
            a.setName(name);
            a.setGroupId(groupId);
        });
    }

    private MavenVersionDescriptor getVersion(MavenArtifactIdDescriptor artifactId, String fqn, String version) {
        return this.getOrCreate(MavenVersionDescriptor.class, fqn, v -> artifactId.equals(v.getArtifactId()), v -> {
            v.setFullQualifiedName(fqn);
            v.setName(version);
            v.setArtifactId(artifactId);
        });
    }

    private <T extends Descriptor> T getOrCreate(Class<T> type, String value, Predicate<T> matcher, Consumer<T> onCreate) {
        try (ResultIterator iterator = this.store.getXOManager().find(type, (Object)value).iterator();){
            while (iterator.hasNext()) {
                Descriptor descriptor = (Descriptor)iterator.next();
                if (!matcher.test(descriptor)) continue;
                Descriptor descriptor2 = descriptor;
                return (T)descriptor2;
            }
        }
        Descriptor descriptor = this.store.create(type);
        onCreate.accept(descriptor);
        return (T)descriptor;
    }

    private static final class GAV {
        private String groupId;
        private String artifactId;
        private String version;

        GAV(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public static GAVBuilder builder() {
            return new GAVBuilder();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GAV)) {
                return false;
            }
            GAV other = (GAV)o;
            String this$groupId = this.groupId;
            String other$groupId = other.groupId;
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.artifactId;
            String other$artifactId = other.artifactId;
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$version = this.version;
            String other$version = other.version;
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.groupId;
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.artifactId;
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $version = this.version;
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        public String toString() {
            return "GAVResolver.GAV(groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + ")";
        }

        public static class GAVBuilder {
            private String groupId;
            private String artifactId;
            private String version;

            GAVBuilder() {
            }

            public GAVBuilder groupId(String groupId) {
                this.groupId = groupId;
                return this;
            }

            public GAVBuilder artifactId(String artifactId) {
                this.artifactId = artifactId;
                return this;
            }

            public GAVBuilder version(String version) {
                this.version = version;
                return this;
            }

            public GAV build() {
                return new GAV(this.groupId, this.artifactId, this.version);
            }

            public String toString() {
                return "GAVResolver.GAV.GAVBuilder(groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + ")";
            }
        }
    }
}

