/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.m2repo.impl.scanner;

import com.buschmais.jqassistant.plugin.m2repo.impl.scanner.ArtifactSearchResult;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import org.apache.lucene.search.Query;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.DefaultIndexer;
import org.apache.maven.index.Indexer;
import org.apache.maven.index.IteratorSearchRequest;
import org.apache.maven.index.IteratorSearchResponse;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.context.ExistingLuceneIndexMismatchException;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.creator.JarFileContentsIndexCreator;
import org.apache.maven.index.creator.MavenArchetypeArtifactInfoIndexCreator;
import org.apache.maven.index.creator.MavenPluginArtifactInfoIndexCreator;
import org.apache.maven.index.creator.MinimalArtifactInfoIndexCreator;
import org.apache.maven.index.expr.SearchExpression;
import org.apache.maven.index.expr.SourcedSearchExpression;
import org.apache.maven.index.updater.DefaultIndexUpdater;
import org.apache.maven.index.updater.IndexUpdateRequest;
import org.apache.maven.index.updater.IndexUpdateResult;
import org.apache.maven.index.updater.IndexUpdater;
import org.apache.maven.index.updater.ResourceFetcher;
import org.apache.maven.index.updater.WagonHelper;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.AbstractTransferListener;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenIndex
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenIndex.class);
    private IndexingContext indexingContext;
    private PlexusContainer plexusContainer;
    private Indexer indexer;
    private String password;
    private String username;

    public MavenIndex(URL repoUrl, File repositoryDirectory, File indexDirectory, String username, String password) throws IOException {
        this.username = username;
        this.password = password;
        try {
            this.createIndexingContext(repoUrl, repositoryDirectory, indexDirectory);
        }
        catch (IllegalArgumentException | PlexusContainerException | ComponentLookupException e) {
            throw new IOException(e);
        }
    }

    private void createIndexingContext(URL repoUrl, File repositoryDirectory, File indexDirectory) throws PlexusContainerException, ComponentLookupException, ExistingLuceneIndexMismatchException, IllegalArgumentException, IOException {
        DefaultContainerConfiguration config = new DefaultContainerConfiguration();
        config.setClassPathScanning("index");
        this.plexusContainer = new DefaultPlexusContainer((ContainerConfiguration)config);
        this.indexer = (Indexer)this.plexusContainer.lookup(DefaultIndexer.class);
        String repoSuffix = repoUrl.getHost();
        File localIndexDir = new File(indexDirectory, "repo-index");
        ArrayList<Object> indexers = new ArrayList<Object>();
        indexers.add(this.plexusContainer.lookup(MinimalArtifactInfoIndexCreator.class));
        indexers.add(this.plexusContainer.lookup(JarFileContentsIndexCreator.class));
        indexers.add(this.plexusContainer.lookup(MavenPluginArtifactInfoIndexCreator.class));
        indexers.add(this.plexusContainer.lookup(MavenArchetypeArtifactInfoIndexCreator.class));
        this.indexingContext = this.indexer.createIndexingContext("jqa-cxt-" + repoSuffix, "jqa-repo-id-" + repoSuffix, repositoryDirectory, localIndexDir, repoUrl.toString(), null, true, true, indexers);
    }

    @Override
    public void close() throws IOException {
        this.indexer.closeIndexingContext(this.indexingContext, false);
    }

    public ArtifactSearchResult getArtifactsSince(Date startDate) throws IOException {
        LOGGER.info("Executing query for artifacts that have been updated since {}.", (Object)startDate);
        long startDateMillis = startDate.getTime();
        Query query = this.indexer.constructQuery(MAVEN.GROUP_ID, (SearchExpression)new SourcedSearchExpression("N/P"));
        IteratorSearchRequest request = new IteratorSearchRequest(query, Collections.singletonList(this.indexingContext), (ctx, ai) -> startDateMillis < ai.getLastModified());
        IteratorSearchResponse artifactInfos = this.indexer.searchIterator(request);
        LOGGER.info("Artifact query returned {} hits (total).", (Object)artifactInfos.getTotalHitsCount());
        return new ArtifactSearchResult((Iterable<ArtifactInfo>)artifactInfos, artifactInfos.getTotalHitsCount());
    }

    public void updateIndex() throws IOException {
        Wagon httpWagon;
        IndexUpdater indexUpdater;
        if (this.indexingContext.getTimestamp() != null) {
            LOGGER.info("Current Maven index timestamp: {}", (Object)this.indexingContext.getTimestamp());
        }
        try {
            indexUpdater = (IndexUpdater)this.plexusContainer.lookup(DefaultIndexUpdater.class);
            httpWagon = (Wagon)this.plexusContainer.lookup(Wagon.class, "http");
        }
        catch (ComponentLookupException e) {
            throw new IOException(e);
        }
        AbstractTransferListener listener = new AbstractTransferListener(){

            public void transferStarted(TransferEvent transferEvent) {
                LOGGER.debug("Downloading " + transferEvent.getResource().getName());
            }

            public void transferProgress(TransferEvent transferEvent, byte[] buffer, int length) {
            }

            public void transferCompleted(TransferEvent transferEvent) {
                LOGGER.debug("Downloading " + transferEvent.getResource().getName() + " successful");
            }
        };
        AuthenticationInfo info = null;
        if (this.username != null && this.password != null) {
            info = new AuthenticationInfo();
            info.setUserName(this.username);
            info.setPassword(this.password);
        }
        LOGGER.info("Updating repository index, this may take a while...");
        WagonHelper.WagonFetcher resourceFetcher = new WagonHelper.WagonFetcher(httpWagon, (TransferListener)listener, info, null);
        IndexUpdateRequest updateRequest = new IndexUpdateRequest(this.indexingContext, (ResourceFetcher)resourceFetcher);
        IndexUpdateResult updateResult = indexUpdater.fetchAndUpdateIndex(updateRequest);
        if (updateResult.isFullUpdate()) {
            LOGGER.info("Received a full update.");
        } else if (updateResult.getTimestamp() == null) {
            LOGGER.info("No update needed, index is up to date.");
        } else {
            LOGGER.info("Received an incremental update.");
        }
        LOGGER.info("Updated Maven index timestamp: {}", (Object)this.indexingContext.getTimestamp());
    }
}

