/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.maven3.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.ArtifactDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.DependsOnDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.java.api.model.JavaArtifactFileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.JavaClassesDirectoryDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.JavaScope;
import com.buschmais.jqassistant.plugin.junit.api.scanner.JunitScope;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.ArtifactFilter;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.ArtifactResolver;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.Coordinates;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.MavenArtifactCoordinates;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenArtifactDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenMainArtifactDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenPomDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenProjectDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenProjectDirectoryDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenTestArtifactDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.EffectiveModel;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.MavenScope;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.ScanInclude;
import com.buschmais.jqassistant.plugin.maven3.impl.scanner.dependency.DependencyScanner;
import com.buschmais.jqassistant.plugin.maven3.impl.scanner.dependency.GraphResolver;
import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenProjectScannerPlugin
extends AbstractScannerPlugin<MavenProject, MavenProjectDirectoryDescriptor> {
    private static final String PROPERTY_NAME_DEPENDENCIES_SCAN = "maven3.dependencies.scan";
    private static final String PROPERTY_NAME_DEPENDENCIES_INCLUDES = "maven3.dependencies.includes";
    private static final String PROPERTY_NAME_DEPENDENCIES_EXCLUDES = "maven3.dependencies.excludes";
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenProjectScannerPlugin.class);
    private final DependencyScanner dependencyScanner;
    private boolean scanDependencies;
    private ArtifactFilter dependencyFilter = null;

    public MavenProjectScannerPlugin() {
        this(new DependencyScanner(new GraphResolver()));
    }

    MavenProjectScannerPlugin(DependencyScanner dependencyScanner) {
        this.dependencyScanner = dependencyScanner;
    }

    protected void configure() {
        this.scanDependencies = this.getBooleanProperty(PROPERTY_NAME_DEPENDENCIES_SCAN, false);
        String dependencyFilterIncludes = this.getStringProperty(PROPERTY_NAME_DEPENDENCIES_INCLUDES, null);
        String dependencyFilterExcludes = this.getStringProperty(PROPERTY_NAME_DEPENDENCIES_EXCLUDES, null);
        this.dependencyFilter = new ArtifactFilter(dependencyFilterIncludes, dependencyFilterExcludes);
    }

    public boolean accepts(MavenProject item, String path, Scope scope) {
        return true;
    }

    public MavenProjectDirectoryDescriptor scan(MavenProject project, String projectPath, Scope scope, Scanner scanner) {
        ScannerContext context = scanner.getContext();
        MavenSession mavenSession = (MavenSession)context.peek(MavenSession.class);
        ProjectBuildingRequest projectBuildingRequest = mavenSession.getProjectBuildingRequest();
        MavenProjectDirectoryDescriptor projectDescriptor = this.resolveProject(project, MavenProjectDirectoryDescriptor.class, context);
        ArtifactResolver artifactResolver = (ArtifactResolver)context.peek(ArtifactResolver.class);
        Artifact artifact = project.getArtifact();
        MavenMainArtifactDescriptor mainArtifactDescriptor = this.getMavenArtifactDescriptor(new MavenArtifactCoordinates(artifact, false), MavenMainArtifactDescriptor.class, artifactResolver, scanner);
        projectDescriptor.getCreatesArtifacts().add(mainArtifactDescriptor);
        MavenTestArtifactDescriptor testArtifactDescriptor = null;
        String testOutputDirectory = project.getBuild().getTestOutputDirectory();
        if (testOutputDirectory != null) {
            testArtifactDescriptor = this.getMavenArtifactDescriptor(new MavenArtifactCoordinates(artifact, true), MavenTestArtifactDescriptor.class, artifactResolver, scanner);
            DependsOnDescriptor dependsOnDescriptor = (DependsOnDescriptor)context.getStore().create((Descriptor)testArtifactDescriptor, DependsOnDescriptor.class, (Descriptor)mainArtifactDescriptor);
            dependsOnDescriptor.setScope("compile");
            projectDescriptor.getCreatesArtifacts().add(testArtifactDescriptor);
        }
        this.resolveDependencyGraph(project, mainArtifactDescriptor, testArtifactDescriptor, scanner, projectBuildingRequest);
        this.scanClassesDirectory(projectDescriptor, mainArtifactDescriptor, project.getBuild().getOutputDirectory(), scanner);
        if (testOutputDirectory != null) {
            this.scanClassesDirectory(projectDescriptor, testArtifactDescriptor, testOutputDirectory, scanner);
        }
        this.addProjectDetails(project, projectDescriptor, scanner);
        this.scanPath(projectDescriptor, project.getBuild().getDirectory() + "/surefire-reports", (Scope)JunitScope.TESTREPORTS, scanner);
        this.scanPath(projectDescriptor, project.getBuild().getDirectory() + "/failsafe-reports", (Scope)JunitScope.TESTREPORTS, scanner);
        List scanIncludes = (List)this.getProperty(ScanInclude.class.getName(), List.class);
        if (scanIncludes != null) {
            for (ScanInclude scanInclude : scanIncludes) {
                String path = scanInclude.getPath();
                URL url = scanInclude.getUrl();
                String scopeName = scanInclude.getScope();
                Scope includeScope = scanner.resolveScope(scopeName);
                Descriptor descriptor = null;
                if (path != null) {
                    descriptor = (Descriptor)this.scanPath(projectDescriptor, path, includeScope, scanner);
                } else if (url != null) {
                    descriptor = scanner.scan((Object)url, url.toString(), includeScope);
                }
                if (descriptor == null || !(descriptor instanceof FileDescriptor)) continue;
                projectDescriptor.getContains().add((FileDescriptor)descriptor);
            }
        }
        return projectDescriptor;
    }

    private <T extends MavenArtifactDescriptor> T getMavenArtifactDescriptor(Coordinates coordinates, Class<T> type, ArtifactResolver artifactResolver, Scanner scanner) {
        MavenArtifactDescriptor mavenArtifactDescriptor = artifactResolver.resolve(coordinates, scanner.getContext());
        return (T)((MavenArtifactDescriptor)scanner.getContext().getStore().addDescriptorType((Descriptor)mavenArtifactDescriptor, type));
    }

    protected <T extends MavenProjectDescriptor> T resolveProject(MavenProject project, Class<T> expectedType, ScannerContext scannerContext) {
        String id;
        Store store = scannerContext.getStore();
        MavenProjectDescriptor projectDescriptor = (MavenProjectDescriptor)store.find(MavenProjectDescriptor.class, id = project.getGroupId() + ":" + project.getArtifactId() + ":" + project.getVersion());
        if (projectDescriptor == null) {
            projectDescriptor = (MavenProjectDescriptor)store.create(expectedType, id);
            projectDescriptor.setName(project.getName());
            projectDescriptor.setGroupId(project.getGroupId());
            projectDescriptor.setArtifactId(project.getArtifactId());
            projectDescriptor.setVersion(project.getVersion());
            projectDescriptor.setPackaging(project.getPackaging());
            projectDescriptor.setFullQualifiedName(id);
        } else if (!expectedType.isAssignableFrom(projectDescriptor.getClass())) {
            projectDescriptor = (MavenProjectDescriptor)store.addDescriptorType((Descriptor)projectDescriptor, expectedType);
        }
        return (T)((MavenProjectDescriptor)expectedType.cast(projectDescriptor));
    }

    private void resolveDependencyGraph(MavenProject project, MavenArtifactDescriptor mainDescriptor, MavenArtifactDescriptor testDescriptor, Scanner scanner, ProjectBuildingRequest projectBuildingRequest) {
        ScannerContext context = scanner.getContext();
        DependencyGraphBuilder dependencyGraphBuilder = (DependencyGraphBuilder)context.peek(DependencyGraphBuilder.class);
        RepositorySystemSession repositorySession = projectBuildingRequest.getRepositorySession();
        DefaultRepositorySystemSession repositorySystemSession = this.getVerboseRepositorySystemSession(repositorySession);
        ProjectBuildingRequest buildingRequest = this.getProjectBuildingRequest(project, projectBuildingRequest, repositorySystemSession);
        DependencyNode rootNode = null;
        try {
            rootNode = dependencyGraphBuilder.buildDependencyGraph(buildingRequest, null);
        }
        catch (DependencyGraphBuilderException e) {
            LOGGER.warn("Cannot resolve dependency graph for " + project, (Throwable)e);
        }
        if (rootNode != null) {
            this.dependencyScanner.evaluate(rootNode, mainDescriptor, testDescriptor, this.scanDependencies, this.dependencyFilter, scanner);
        }
    }

    private DefaultRepositorySystemSession getVerboseRepositorySystemSession(RepositorySystemSession repositorySession) {
        DefaultRepositorySystemSession repositorySystemSession = new DefaultRepositorySystemSession(repositorySession);
        repositorySystemSession.setConfigProperty("aether.conflictResolver.verbose", (Object)"true");
        return repositorySystemSession;
    }

    private ProjectBuildingRequest getProjectBuildingRequest(MavenProject project, ProjectBuildingRequest projectBuildingRequest, DefaultRepositorySystemSession repositorySystemSession) {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(projectBuildingRequest);
        buildingRequest.setRepositorySession((RepositorySystemSession)repositorySystemSession);
        buildingRequest.setProject(project);
        return buildingRequest;
    }

    private void addProjectDetails(MavenProject project, MavenProjectDirectoryDescriptor projectDescriptor, Scanner scanner) {
        ScannerContext scannerContext = scanner.getContext();
        this.addParent(project, projectDescriptor, scannerContext);
        this.addModules(project, projectDescriptor, scannerContext);
        this.addModel(project, projectDescriptor, scanner);
    }

    private void addModel(MavenProject project, MavenProjectDirectoryDescriptor projectDescriptor, Scanner scanner) {
        File pomXmlFile = project.getFile();
        FileDescriptor mavenPomXmlDescriptor = (FileDescriptor)scanner.scan((Object)pomXmlFile, pomXmlFile.getAbsolutePath(), (Scope)MavenScope.PROJECT);
        projectDescriptor.setModel(mavenPomXmlDescriptor);
        MavenPomDescriptor effectiveModelDescriptor = (MavenPomDescriptor)scanner.getContext().getStore().create(MavenPomDescriptor.class);
        EffectiveModel model = new EffectiveModel(project.getModel());
        scanner.getContext().push(MavenPomDescriptor.class, (Object)effectiveModelDescriptor);
        scanner.scan((Object)model, pomXmlFile.getAbsolutePath(), (Scope)MavenScope.PROJECT);
        scanner.getContext().pop(MavenPomDescriptor.class);
        projectDescriptor.setEffectiveModel(effectiveModelDescriptor);
    }

    private void addParent(MavenProject project, MavenProjectDirectoryDescriptor projectDescriptor, ScannerContext scannerContext) {
        MavenProject parent = project.getParent();
        if (parent != null) {
            MavenProjectDescriptor parentDescriptor = this.resolveProject(parent, MavenProjectDescriptor.class, scannerContext);
            projectDescriptor.setParent(parentDescriptor);
        }
    }

    private void addModules(MavenProject project, MavenProjectDirectoryDescriptor projectDescriptor, ScannerContext scannerContext) {
        File projectDirectory = project.getBasedir();
        HashSet<File> modules = new HashSet<File>();
        for (String moduleName : project.getModules()) {
            File module = new File(projectDirectory, moduleName);
            modules.add(module);
        }
        for (MavenProject module : project.getCollectedProjects()) {
            if (!modules.contains(module.getBasedir())) continue;
            MavenProjectDescriptor moduleDescriptor = this.resolveProject(module, MavenProjectDescriptor.class, scannerContext);
            projectDescriptor.getModules().add(moduleDescriptor);
        }
    }

    private void scanClassesDirectory(MavenProjectDirectoryDescriptor projectDescriptor, MavenArtifactDescriptor artifactDescriptor, String directoryName, Scanner scanner) {
        File directory = new File(directoryName);
        if (directory.exists()) {
            this.scanArtifact(projectDescriptor, artifactDescriptor, directory, directoryName, scanner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaArtifactFileDescriptor scanArtifact(MavenProjectDirectoryDescriptor projectDescriptor, ArtifactDescriptor artifactDescriptor, File file, String path, Scanner scanner) {
        JavaArtifactFileDescriptor javaArtifactFileDescriptor = (JavaArtifactFileDescriptor)scanner.getContext().getStore().addDescriptorType((Descriptor)artifactDescriptor, JavaClassesDirectoryDescriptor.class);
        ScannerContext context = scanner.getContext();
        context.push(JavaArtifactFileDescriptor.class, (Object)javaArtifactFileDescriptor);
        try {
            JavaArtifactFileDescriptor javaArtifactFileDescriptor2 = (JavaArtifactFileDescriptor)this.scanFile(projectDescriptor, file, path, (Scope)JavaScope.CLASSPATH, scanner);
            return javaArtifactFileDescriptor2;
        }
        finally {
            context.pop(JavaArtifactFileDescriptor.class);
        }
    }

    private <F extends FileDescriptor> F scanPath(MavenProjectDirectoryDescriptor projectDescriptor, String path, Scope scope, Scanner scanner) {
        File file = new File(path);
        if (file.exists()) {
            return this.scanFile(projectDescriptor, file, path, scope, scanner);
        }
        LOGGER.debug(file.getAbsolutePath() + " does not exist, skipping.");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <F extends FileDescriptor> F scanFile(MavenProjectDirectoryDescriptor projectDescriptor, File file, String path, Scope scope, Scanner scanner) {
        scanner.getContext().push(MavenProjectDirectoryDescriptor.class, (Object)projectDescriptor);
        try {
            FileDescriptor fileDescriptor = (FileDescriptor)scanner.scan((Object)file, path, scope);
            return (F)fileDescriptor;
        }
        finally {
            scanner.getContext().pop(MavenProjectDirectoryDescriptor.class);
        }
    }
}

