/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.maven3.impl.scanner.dependency;

import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.ArtifactResolver;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.MavenArtifactCoordinates;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenArtifactDescriptor;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;

public class GraphResolver {
    Map<Artifact, Set<Artifact>> resolve(DependencyNode root, MavenArtifactDescriptor mainDescriptor, MavenArtifactDescriptor testDescriptor, ScannerContext context) {
        DependencyGraphVisitor visitor = new DependencyGraphVisitor();
        root.accept((DependencyNodeVisitor)visitor);
        Map<Artifact, Set<Artifact>> dependencies = visitor.getDependencies();
        this.createGraph(dependencies, root.getArtifact(), mainDescriptor, testDescriptor, context);
        return Collections.unmodifiableMap(dependencies);
    }

    private void createGraph(Map<Artifact, Set<Artifact>> dependencies, Artifact mainArtifact, MavenArtifactDescriptor mainArtifactDescriptor, MavenArtifactDescriptor testArtifactDescriptor, ScannerContext context) {
        for (Map.Entry<Artifact, Set<Artifact>> entry : dependencies.entrySet()) {
            Artifact dependentArtifact = entry.getKey();
            Set<Artifact> dependencyArtifacts = entry.getValue();
            for (Artifact dependencyArtifact : dependencyArtifacts) {
                MavenArtifactDescriptor artifactDescriptor = this.resolve(dependencyArtifact, context);
                if (dependentArtifact.equals(mainArtifact)) {
                    if ("test".equals(dependencyArtifact.getScope())) {
                        testArtifactDescriptor.addDependency(artifactDescriptor, dependencyArtifact.getScope(), dependencyArtifact.isOptional());
                        continue;
                    }
                    mainArtifactDescriptor.addDependency(artifactDescriptor, dependencyArtifact.getScope(), dependencyArtifact.isOptional());
                    continue;
                }
                MavenArtifactDescriptor dependentDescriptor = this.resolve(dependentArtifact, context);
                dependentDescriptor.addDependency(artifactDescriptor, dependencyArtifact.getScope(), dependencyArtifact.isOptional());
            }
        }
    }

    private MavenArtifactDescriptor resolve(Artifact artifact, ScannerContext context) {
        ArtifactResolver artifactResolver = (ArtifactResolver)context.peek(ArtifactResolver.class);
        return artifactResolver.resolve(new MavenArtifactCoordinates(artifact, false), context);
    }

    private class DependencyGraphVisitor
    implements DependencyNodeVisitor {
        private final Deque<DependencyNode> stack = new LinkedList<DependencyNode>();
        private Map<Artifact, Set<Artifact>> dependencies = new LinkedHashMap<Artifact, Set<Artifact>>();

        private DependencyGraphVisitor() {
        }

        public boolean visit(DependencyNode node) {
            this.stack.push(node);
            return true;
        }

        public boolean endVisit(DependencyNode dependencyNode) {
            this.stack.pop();
            DependencyNode dependentNode = this.stack.peek();
            if (dependentNode != null) {
                this.dependencies.computeIfAbsent(dependentNode.getArtifact(), key -> new HashSet()).add(dependencyNode.getArtifact());
            }
            return true;
        }

        public Map<Artifact, Set<Artifact>> getDependencies() {
            return this.dependencies;
        }
    }
}

