/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.maven3.api.artifact;

import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.plugin.common.api.scanner.FileResolver;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.ArtifactResolver;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.Coordinates;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.MavenArtifactHelper;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenArtifactDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenArtifactFileDescriptor;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class MavenRepositoryArtifactResolver
implements ArtifactResolver {
    private static final String CACHE_KEY = MavenRepositoryArtifactResolver.class.getName();
    private final String repositoryRoot;
    private final FileResolver fileResolver;

    public MavenRepositoryArtifactResolver(File repositoryRoot, FileResolver fileResolver) {
        this.repositoryRoot = repositoryRoot.getAbsolutePath().replace('\\', '/');
        this.fileResolver = fileResolver;
    }

    @Override
    public MavenArtifactDescriptor resolve(Coordinates coordinates, ScannerContext scannerContext) {
        String fqn = MavenArtifactHelper.getId(coordinates);
        return (MavenArtifactDescriptor)scannerContext.getStore().getCache(CACHE_KEY).get((Object)fqn, key -> {
            String fileName = this.getFileName(coordinates);
            MavenArtifactFileDescriptor mavenArtifactDescriptor = (MavenArtifactFileDescriptor)this.fileResolver.require(fileName, MavenArtifactFileDescriptor.class, scannerContext);
            MavenArtifactHelper.setCoordinates(mavenArtifactDescriptor, coordinates);
            return mavenArtifactDescriptor;
        });
    }

    private String getFileName(Coordinates coordinates) {
        String group = coordinates.getGroup();
        String name = coordinates.getName();
        String version = coordinates.getVersion();
        String classifier = coordinates.getClassifier();
        String type = coordinates.getType();
        StringBuilder fileName = new StringBuilder(this.repositoryRoot);
        if (StringUtils.isNotEmpty((CharSequence)group)) {
            fileName.append('/');
            fileName.append(group.replace('.', '/'));
        }
        fileName.append('/');
        fileName.append(name);
        if (StringUtils.isNotEmpty((CharSequence)version)) {
            fileName.append('/');
            fileName.append(version);
        }
        fileName.append('/');
        fileName.append(name);
        if (StringUtils.isNotEmpty((CharSequence)version)) {
            fileName.append('-');
            fileName.append(version);
        }
        if (StringUtils.isNotEmpty((CharSequence)classifier)) {
            fileName.append('-');
            fileName.append(classifier);
        }
        fileName.append('.');
        fileName.append(type);
        return fileName.toString();
    }
}

