/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.maven3.impl.scanner.dependency;

import com.buschmais.jqassistant.core.scanner.api.DefaultScope;
import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.plugin.common.api.model.FileContainerDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.ArtifactFilter;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.ArtifactResolver;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.MavenArtifactCoordinates;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenArtifactDescriptor;
import com.buschmais.jqassistant.plugin.maven3.impl.scanner.dependency.GraphResolver;
import com.buschmais.xo.spi.reflection.DependencyResolver;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.shared.dependency.graph.DependencyNode;

public class DependencyScanner {
    private final GraphResolver graphResolver;

    public DependencyScanner(GraphResolver graphResolver) {
        this.graphResolver = graphResolver;
    }

    public void evaluate(DependencyNode rootNode, MavenArtifactDescriptor mainDescriptor, MavenArtifactDescriptor testDescriptor, boolean scanDependencies, ArtifactFilter dependencyFilter, ArtifactRepository localRepository, Scanner scanner) {
        Map<Artifact, Set<Artifact>> dependencies = this.resolveDependencyGraph(rootNode, mainDescriptor, testDescriptor, scanner.getContext());
        if (scanDependencies) {
            this.scanDependencyArtifacts(rootNode, dependencies, dependencyFilter, localRepository, scanner);
        }
    }

    private Map<Artifact, Set<Artifact>> resolveDependencyGraph(DependencyNode rootNode, MavenArtifactDescriptor mainDescriptor, MavenArtifactDescriptor testDescriptor, ScannerContext context) {
        return this.graphResolver.resolve(rootNode, mainDescriptor, testDescriptor, context);
    }

    private void scanDependencyArtifacts(DependencyNode rootNode, Map<Artifact, Set<Artifact>> dependencies, ArtifactFilter dependencyFilter, ArtifactRepository localRepository, Scanner scanner) {
        List artifacts = DependencyResolver.newInstance(dependencies.keySet(), artifact -> dependencies.getOrDefault(artifact, Collections.emptySet())).resolve();
        ArtifactResolver artifactResolver = (ArtifactResolver)scanner.getContext().peek(ArtifactResolver.class);
        for (Artifact artifact2 : artifacts) {
            if (artifact2.equals(rootNode.getArtifact()) || !dependencyFilter.match(artifact2)) continue;
            File artifactFile = localRepository.find(artifact2).getFile();
            FileDescriptor fileDescriptor = artifactResolver.resolve(new MavenArtifactCoordinates(artifact2, false), FileDescriptor.class, scanner.getContext());
            if (artifactFile == null || fileDescriptor instanceof FileContainerDescriptor) continue;
            scanner.scan((Object)artifactFile, artifactFile.getAbsolutePath(), (Scope)DefaultScope.NONE);
        }
    }
}

