/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.maven3.api.artifact;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.artifact.filter.PatternExcludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.PatternIncludesArtifactFilter;

public class ArtifactFilter {
    private final List<String> includes;
    private final List<String> excludes;

    public ArtifactFilter(String includes, String excludes) {
        this.includes = this.parse(includes);
        this.excludes = this.parse(excludes);
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public boolean match(Artifact artifact) {
        PatternIncludesArtifactFilter includesFilter = this.includes != null ? new PatternIncludesArtifactFilter(this.includes) : null;
        PatternExcludesArtifactFilter excludesFilter = this.excludes != null ? new PatternExcludesArtifactFilter(this.excludes) : null;
        return !(includesFilter != null && !includesFilter.include(artifact) || excludesFilter != null && !excludesFilter.include(artifact));
    }

    private List<String> parse(String patterns) {
        if (patterns == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String pattern : patterns.split(",")) {
            String trimmed = pattern.trim();
            if (trimmed.isEmpty()) continue;
            result.add(trimmed);
        }
        return Collections.unmodifiableList(result);
    }
}

