/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.base;

import schemacrawler.schemacrawler.Config;
import schemacrawler.tools.text.base.BaseTextOptions;

public class BaseTextOptionsBuilder {
    private final BaseTextOptions options;

    public BaseTextOptionsBuilder() {
        this(null);
    }

    public BaseTextOptionsBuilder(Config config) {
        this.options = new BaseTextOptions(config){
            private static final long serialVersionUID = 394786618097261880L;
        };
    }

    public BaseTextOptionsBuilder appendOutput() {
        this.options.setAppendOutput(true);
        return this;
    }

    public BaseTextOptionsBuilder hideFooter() {
        this.options.setNoFooter(true);
        return this;
    }

    public BaseTextOptionsBuilder hideHeader() {
        this.options.setNoHeader(true);
        return this;
    }

    public BaseTextOptionsBuilder hideInfo() {
        this.options.setNoInfo(true);
        return this;
    }

    public BaseTextOptionsBuilder overwriteOutput() {
        this.options.setAppendOutput(false);
        return this;
    }

    public BaseTextOptionsBuilder showFooter() {
        this.options.setNoFooter(false);
        return this;
    }

    public BaseTextOptionsBuilder showHeader() {
        this.options.setNoHeader(false);
        return this;
    }

    public BaseTextOptionsBuilder showInfo() {
        this.options.setNoInfo(false);
        return this;
    }

    public BaseTextOptionsBuilder sortTableColumns() {
        this.options.setAlphabeticalSortForTableColumns(true);
        return this;
    }

    public BaseTextOptionsBuilder sortTables() {
        this.options.setAlphabeticalSortForTables(true);
        return this;
    }

    public Config toConfig() {
        return this.options.toConfig();
    }

    public String toString() {
        return this.options.toString();
    }
}

