/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collection;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableColumnDataType;
import schemacrawler.crawl.MutableRoutine;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.JavaSqlType;
import schemacrawler.schema.Schema;
import schemacrawler.schema.SchemaReference;
import schemacrawler.utility.TypeMap;
import sf.util.Utility;

abstract class AbstractRetriever {
    private final RetrieverConnection retrieverConnection;
    final MutableCatalog catalog;

    AbstractRetriever() throws SQLException {
        this(null, null);
    }

    AbstractRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog) throws SQLException {
        this.retrieverConnection = retrieverConnection;
        this.catalog = catalog;
    }

    boolean belongsToSchema(DatabaseObject dbObject, String catalogName, String schemaName) {
        if (dbObject == null) {
            return false;
        }
        boolean supportsCatalogs = this.retrieverConnection.isSupportsCatalogs();
        boolean belongsToCatalog = true;
        boolean belongsToSchema = true;
        if (supportsCatalogs) {
            String dbObjectCatalogName = dbObject.getSchema().getCatalogName();
            if (catalogName != null && !this.unquotedName(catalogName).equals(this.unquotedName(dbObjectCatalogName))) {
                belongsToCatalog = false;
            }
        }
        String dbObjectSchemaName = dbObject.getSchema().getName();
        if (schemaName != null && !this.unquotedName(schemaName).equals(this.unquotedName(dbObjectSchemaName))) {
            belongsToSchema = false;
        }
        return belongsToCatalog && belongsToSchema;
    }

    Connection getDatabaseConnection() {
        return this.retrieverConnection.getConnection();
    }

    DatabaseMetaData getMetaData() {
        return this.retrieverConnection.getMetaData();
    }

    RetrieverConnection getRetrieverConnection() {
        return this.retrieverConnection;
    }

    Collection<Schema> getSchemas() {
        return this.catalog.getSchemas();
    }

    MutableColumnDataType lookupOrCreateColumnDataType(Schema schema, int javaSqlType, String databaseSpecificTypeName) {
        return this.lookupOrCreateColumnDataType(schema, javaSqlType, databaseSpecificTypeName, null);
    }

    MutableColumnDataType lookupOrCreateColumnDataType(Schema schema, int javaSqlTypeInt, String databaseSpecificTypeName, String mappedClassName) {
        MutableColumnDataType columnDataType = this.catalog.getColumnDataType(schema, databaseSpecificTypeName);
        if (columnDataType == null) {
            columnDataType = this.catalog.getSystemColumnDataType(databaseSpecificTypeName);
        }
        if (columnDataType == null) {
            columnDataType = new MutableColumnDataType(schema, databaseSpecificTypeName);
            JavaSqlType javaSqlType = this.retrieverConnection.getJavaSqlTypes().get(javaSqlTypeInt);
            columnDataType.setJavaSqlType(javaSqlType);
            if (Utility.isBlank(mappedClassName)) {
                TypeMap typeMap = this.retrieverConnection.getTypeMap();
                Object mappedClass = typeMap.containsKey(databaseSpecificTypeName) ? typeMap.get(databaseSpecificTypeName) : typeMap.get(javaSqlType.getJavaSqlTypeName());
                columnDataType.setTypeMappedClass((Class<?>)mappedClass);
            } else {
                columnDataType.setTypeMappedClass(mappedClassName);
            }
            this.catalog.addColumnDataType(columnDataType);
        }
        return columnDataType;
    }

    MutableRoutine lookupRoutine(String catalogName, String schemaName, String routineName, String specificName) {
        MutableRoutine routine = null;
        SchemaReference schema = new SchemaReference(catalogName, schemaName);
        if (schema != null) {
            String routineLookupName = !Utility.isBlank(specificName) ? specificName : routineName;
            routine = (MutableRoutine)this.catalog.getRoutine(new SchemaReference(catalogName, schemaName), routineLookupName);
        }
        return routine;
    }

    MutableTable lookupTable(String catalogName, String schemaName, String tableName) {
        MutableTable table = null;
        SchemaReference schema = new SchemaReference(catalogName, schemaName);
        if (schema != null) {
            table = this.catalog.getTable(new SchemaReference(catalogName, schemaName), tableName);
        }
        return table;
    }

    String quotedName(String name) {
        String quotedName;
        RetrieverConnection retrieverConnection = this.getRetrieverConnection();
        if (retrieverConnection != null && !Utility.isBlank(name)) {
            String identifierQuoteString = retrieverConnection.getIdentifierQuoteString();
            quotedName = retrieverConnection.needsToBeQuoted(name) ? identifierQuoteString + name + identifierQuoteString : name;
        } else {
            quotedName = name;
        }
        return quotedName;
    }

    String unquotedName(String name) {
        String unquotedName;
        RetrieverConnection retrieverConnection = this.getRetrieverConnection();
        if (retrieverConnection != null && !Utility.isBlank(name)) {
            String identifierQuoteString = retrieverConnection.getIdentifierQuoteString();
            if (name.startsWith(identifierQuoteString) && name.endsWith(identifierQuoteString)) {
                int quoteLength = identifierQuoteString.length();
                unquotedName = name.substring(quoteLength, name.length() - quoteLength);
            } else {
                unquotedName = name;
            }
        } else {
            unquotedName = name;
        }
        return unquotedName;
    }
}

