/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schema;

import java.util.logging.Level;
import java.util.logging.Logger;

public enum SearchableType {
    unknown(-1, "unknown"),
    predNone(0, "not searchable"),
    predChar(1, "only searchable with where .. like"),
    predBasic(2, "searchable except with where .. like"),
    searchable(3, "searchable");

    private static final Logger LOGGER;
    private final int id;
    private final String text;

    public static SearchableType valueOf(int id) {
        for (SearchableType type : SearchableType.values()) {
            if (type.getId() != id) continue;
            return type;
        }
        LOGGER.log(Level.FINE, "Unknown id " + id);
        return unknown;
    }

    private SearchableType(int id, String text) {
        this.id = id;
        this.text = text;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return this.text;
    }

    static {
        LOGGER = Logger.getLogger(SearchableType.class.getName());
    }
}

