/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.Collection;
import schemacrawler.crawl.AbstractColumn;
import schemacrawler.crawl.MutablePrivilege;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.schema.Column;
import schemacrawler.schema.Privilege;
import schemacrawler.schema.Table;

class MutableColumn
extends AbstractColumn<Table>
implements Column {
    private static final long serialVersionUID = 3834591019449528633L;
    private String defaultValue;
    private boolean isAutoIncremented;
    private boolean isGenerated;
    private boolean isPartOfPrimaryKey;
    private boolean isPartOfIndex;
    private Column referencedColumn;
    private final NamedObjectList<MutablePrivilege<Column>> privileges = new NamedObjectList();

    MutableColumn(Table parent, String name) {
        super(parent, name);
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public MutablePrivilege<Column> getPrivilege(String name) {
        return this.privileges.lookup(this, name);
    }

    @Override
    public Collection<Privilege<Column>> getPrivileges() {
        return new ArrayList<Privilege<Column>>(this.privileges.values());
    }

    @Override
    public Column getReferencedColumn() {
        return this.referencedColumn;
    }

    @Override
    public boolean isAutoIncremented() {
        return this.isAutoIncremented;
    }

    @Override
    public boolean isGenerated() {
        return this.isGenerated;
    }

    @Override
    public boolean isPartOfForeignKey() {
        return this.referencedColumn != null;
    }

    @Override
    public boolean isPartOfPrimaryKey() {
        return this.isPartOfPrimaryKey;
    }

    @Override
    public boolean isPartOfIndex() {
        return this.isPartOfIndex;
    }

    void addPrivilege(MutablePrivilege<Column> privilege) {
        this.privileges.add(privilege);
    }

    void setAutoIncremented(boolean isAutoIncremented) {
        this.isAutoIncremented = isAutoIncremented;
    }

    void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    void setGenerated(boolean isGenerated) {
        this.isGenerated = isGenerated;
    }

    void markAsPartOfPrimaryKey() {
        this.isPartOfPrimaryKey = true;
    }

    void markAsPartOfIndex() {
        this.isPartOfIndex = true;
    }

    void setReferencedColumn(Column referencedColumn) {
        this.referencedColumn = referencedColumn;
    }
}

