/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.RetrieverUtility;
import schemacrawler.schema.TableType;

class TableTypes {
    private static final Logger LOGGER = Logger.getLogger(TableTypes.class.getName());
    private final Collection<TableType> tableTypes = new HashSet<TableType>();

    TableTypes(Connection connection) {
        if (connection != null) {
            try {
                ResultSet tableTypesResults = connection.getMetaData().getTableTypes();
                List<String> tableTypesList = RetrieverUtility.readResultsVector(tableTypesResults);
                for (String tableType : tableTypesList) {
                    this.tableTypes.add(new TableType(tableType));
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Could not obtain table types from connection", e);
            }
        }
    }

    public String toString() {
        return this.tableTypes.toString();
    }

    String[] filterUnknown(Collection<String> tableTypeStrings) {
        if (tableTypeStrings == null) {
            return null;
        }
        if (tableTypeStrings.isEmpty()) {
            return new String[0];
        }
        ArrayList<String> filteredTableTypes = new ArrayList<String>();
        for (String tableTypeString : tableTypeStrings) {
            TableType tableType = this.lookupTableType(tableTypeString);
            if (tableType.equals(TableType.UNKNOWN)) continue;
            filteredTableTypes.add(tableType.getTableType());
        }
        Collections.sort(filteredTableTypes);
        return filteredTableTypes.toArray(new String[filteredTableTypes.size()]);
    }

    TableType lookupTableType(String tableTypeString) {
        for (TableType tableType : this.tableTypes) {
            if (!tableType.isEqualTo(tableTypeString)) continue;
            return tableType;
        }
        return TableType.UNKNOWN;
    }
}

