/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schema;

import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.RoutineColumnType;

public enum FunctionColumnType implements RoutineColumnType
{
    unknown(0, "unknown"),
    in(1, "in"),
    inOut(2, "in/ out"),
    out(3, "out"),
    returnValue(5, "return"),
    result(3, "result");

    private static final Logger LOGGER;
    private final int id;
    private final String text;

    public static FunctionColumnType valueOf(int id) {
        for (FunctionColumnType type : FunctionColumnType.values()) {
            if (type.getId() != id) continue;
            return type;
        }
        LOGGER.log(Level.FINE, "Unknown id " + id);
        return unknown;
    }

    private FunctionColumnType(int id, String text) {
        this.id = id;
        this.text = text;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return this.text;
    }

    static {
        LOGGER = Logger.getLogger(FunctionColumnType.class.getName());
    }
}

