/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schema;

import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.RoutineReturnType;

public enum ProcedureReturnType implements RoutineReturnType
{
    unknown(0, "result unknown"),
    noResult(1, "no result"),
    returnsResult(2, "returns result");

    private static final Logger LOGGER;
    private final int id;
    private final String text;

    public static ProcedureReturnType valueOf(int id) {
        for (ProcedureReturnType type : ProcedureReturnType.values()) {
            if (type.getId() != id) continue;
            return type;
        }
        LOGGER.log(Level.FINE, "Unknown id " + id);
        return unknown;
    }

    private ProcedureReturnType(int id, String text) {
        this.id = id;
        this.text = text;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return this.text;
    }

    static {
        LOGGER = Logger.getLogger(ProcedureReturnType.class.getName());
    }
}

