/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.Options;
import sf.util.Utility;

public class DatabaseSpecificOverrideOptions
implements Options {
    private static final long serialVersionUID = -5593417085363698921L;
    private static final String SC_OVERRIDE_SUPPORTS_SCHEMAS = "schemacrawler.override.supports_schemas";
    private static final String SC_OVERRIDE_SUPPORTS_CATALOGS = "schemacrawler.override.supports_catalogs";
    private static final String SC_OVERRIDE_SUPPORTS_IDENTIFIER_QUOTE_STRING = "schemacrawler.override.identifier_quote_string";
    private Boolean supportsSchemas;
    private Boolean supportsCatalogs;
    private String identifierQuoteString;

    public DatabaseSpecificOverrideOptions() {
    }

    public DatabaseSpecificOverrideOptions(Config config) {
        this();
        Config configProperties = config == null ? new Config() : config;
        if (configProperties.hasValue(SC_OVERRIDE_SUPPORTS_SCHEMAS)) {
            this.setSupportsSchemas(configProperties.getBooleanValue(SC_OVERRIDE_SUPPORTS_SCHEMAS));
        }
        if (configProperties.hasValue(SC_OVERRIDE_SUPPORTS_CATALOGS)) {
            this.setSupportsCatalogs(configProperties.getBooleanValue(SC_OVERRIDE_SUPPORTS_CATALOGS));
        }
        if (configProperties.hasValue(SC_OVERRIDE_SUPPORTS_IDENTIFIER_QUOTE_STRING)) {
            this.setIdentifierQuoteString(configProperties.getStringValue(SC_OVERRIDE_SUPPORTS_IDENTIFIER_QUOTE_STRING, null));
        }
    }

    public String getIdentifierQuoteString() {
        if (!this.hasOverrideForIdentifierQuoteString()) {
            return "";
        }
        return this.identifierQuoteString;
    }

    public boolean hasOverrideForIdentifierQuoteString() {
        return !Utility.isBlank(this.identifierQuoteString);
    }

    public boolean hasOverrideForSupportsCatalogs() {
        return this.supportsCatalogs != null;
    }

    public boolean hasOverrideForSupportsSchemas() {
        return this.supportsSchemas != null;
    }

    public boolean isSupportsCatalogs() {
        if (this.supportsCatalogs == null) {
            return true;
        }
        return this.supportsCatalogs;
    }

    public boolean isSupportsSchemas() {
        if (this.supportsSchemas == null) {
            return true;
        }
        return this.supportsSchemas;
    }

    public void setIdentifierQuoteString(String identifierQuoteString) {
        this.identifierQuoteString = identifierQuoteString;
    }

    public void setSupportsCatalogs(boolean supportsCatalogs) {
        this.supportsCatalogs = supportsCatalogs;
    }

    public void setSupportsSchemas(boolean supportsSchemas) {
        this.supportsSchemas = supportsSchemas;
    }

    public void unsetIdentifierQuoteString() {
        this.identifierQuoteString = null;
    }

    public void unsetSupportsCatalogs() {
        this.supportsCatalogs = null;
    }

    public void unsetSupportsSchemas() {
        this.supportsSchemas = null;
    }
}

