/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.util.HashMap;
import java.util.Map;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.Options;
import sf.util.ObjectToString;
import sf.util.Utility;

public final class InformationSchemaViews
implements Options {
    private static final long serialVersionUID = 3587581365346059044L;
    private final Map<InformationSchemaKey, String> informationSchemaQueries = new HashMap<InformationSchemaKey, String>();

    public InformationSchemaViews() {
        this(null);
    }

    InformationSchemaViews(Map<String, String> informationSchemaViewsSql) {
        if (informationSchemaViewsSql != null) {
            for (InformationSchemaKey key : InformationSchemaKey.values()) {
                if (!informationSchemaViewsSql.containsKey(key.getLookupKey())) continue;
                try {
                    this.informationSchemaQueries.put(key, informationSchemaViewsSql.get(key.getLookupKey()));
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
        }
    }

    public String getAdditionalColumnAttributesSql() {
        return this.informationSchemaQueries.get((Object)InformationSchemaKey.ADDITIONAL_COLUMN_ATTRIBUTES);
    }

    public String getAdditionalTableAttributesSql() {
        return this.informationSchemaQueries.get((Object)InformationSchemaKey.ADDITIONAL_TABLE_ATTRIBUTES);
    }

    public String getExtIndexesSql() {
        return this.informationSchemaQueries.get((Object)InformationSchemaKey.EXT_INDEXES);
    }

    public String getExtTableConstraintsSql() {
        return this.informationSchemaQueries.get((Object)InformationSchemaKey.EXT_TABLE_CONSTRAINTS);
    }

    public String getExtTablesSql() {
        return this.informationSchemaQueries.get((Object)InformationSchemaKey.EXT_TABLES);
    }

    public String getOverrideTypeInfoSql() {
        return this.informationSchemaQueries.get((Object)InformationSchemaKey.OVERRIDE_TYPE_INFO);
    }

    public String getRoutinesSql() {
        return this.informationSchemaQueries.get((Object)InformationSchemaKey.ROUTINES);
    }

    public String getSchemataSql() {
        return this.informationSchemaQueries.get((Object)InformationSchemaKey.SCHEMATA);
    }

    public String getSequencesSql() {
        return this.informationSchemaQueries.get((Object)InformationSchemaKey.SEQUENCES);
    }

    public String getSynonymsSql() {
        return this.informationSchemaQueries.get((Object)InformationSchemaKey.EXT_SYNONYMS);
    }

    public String getTableConstraintsColumnsSql() {
        return this.informationSchemaQueries.get((Object)InformationSchemaKey.CONSTRAINT_COLUMN_USAGE);
    }

    public String getTableConstraintsSql() {
        return this.informationSchemaQueries.get((Object)InformationSchemaKey.TABLE_CONSTRAINTS);
    }

    public String getTriggersSql() {
        return this.informationSchemaQueries.get((Object)InformationSchemaKey.TRIGGERS);
    }

    public String getViewsSql() {
        return this.informationSchemaQueries.get((Object)InformationSchemaKey.VIEWS);
    }

    public boolean hasAdditionalColumnAttributesSql() {
        return this.informationSchemaQueries.containsKey((Object)InformationSchemaKey.ADDITIONAL_COLUMN_ATTRIBUTES);
    }

    public boolean hasAdditionalTableAttributesSql() {
        return this.informationSchemaQueries.containsKey((Object)InformationSchemaKey.ADDITIONAL_TABLE_ATTRIBUTES);
    }

    public boolean hasExtIndexesSql() {
        return this.informationSchemaQueries.containsKey((Object)InformationSchemaKey.EXT_INDEXES);
    }

    public boolean hasExtTableConstraintsSql() {
        return this.informationSchemaQueries.containsKey((Object)InformationSchemaKey.EXT_TABLE_CONSTRAINTS);
    }

    public boolean hasExtTablesSql() {
        return this.informationSchemaQueries.containsKey((Object)InformationSchemaKey.EXT_TABLES);
    }

    public boolean hasOverrideTypeInfoSql() {
        return this.informationSchemaQueries.containsKey((Object)InformationSchemaKey.OVERRIDE_TYPE_INFO);
    }

    public boolean hasRoutinesSql() {
        return this.informationSchemaQueries.containsKey((Object)InformationSchemaKey.ROUTINES);
    }

    public boolean hasSchemataSql() {
        return this.informationSchemaQueries.containsKey((Object)InformationSchemaKey.SCHEMATA);
    }

    public boolean hasSequencesSql() {
        return this.informationSchemaQueries.containsKey((Object)InformationSchemaKey.SEQUENCES);
    }

    public boolean hasSynonymsSql() {
        return this.informationSchemaQueries.containsKey((Object)InformationSchemaKey.EXT_SYNONYMS);
    }

    public boolean hasTableConstraintsColumnsSql() {
        return this.informationSchemaQueries.containsKey((Object)InformationSchemaKey.CONSTRAINT_COLUMN_USAGE);
    }

    public boolean hasTableConstraintsSql() {
        return this.informationSchemaQueries.containsKey((Object)InformationSchemaKey.TABLE_CONSTRAINTS);
    }

    public boolean hasTriggerSql() {
        return this.informationSchemaQueries.containsKey((Object)InformationSchemaKey.TRIGGERS);
    }

    public boolean hasViewsSql() {
        return this.informationSchemaQueries.containsKey((Object)InformationSchemaKey.VIEWS);
    }

    public void loadResource(String classpath) {
        for (InformationSchemaKey key : InformationSchemaKey.values()) {
            String resource = classpath == null ? key.getResource() : String.format("%s/%s", classpath, key.getResource());
            String sql = Utility.readResourceFully(resource);
            if (Utility.isBlank(sql)) continue;
            this.informationSchemaQueries.put(key, sql);
        }
    }

    public void setAdditionalColumnAttributesSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.ADDITIONAL_COLUMN_ATTRIBUTES, sql);
    }

    public void setAdditionalTableAttributesSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.ADDITIONAL_TABLE_ATTRIBUTES, sql);
    }

    public void setExtIndexesSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.EXT_INDEXES, sql);
    }

    public void setExtTableConstraintsSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.EXT_TABLE_CONSTRAINTS, sql);
    }

    public void setExtTablesSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.EXT_TABLES, sql);
    }

    public void setOverrideTypeInfoSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.OVERRIDE_TYPE_INFO, sql);
    }

    public void setRoutinesSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.ROUTINES, sql);
    }

    public void setSchemataSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.SCHEMATA, sql);
    }

    public void setSequencesSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.SEQUENCES, sql);
    }

    public void setSynonymsSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.EXT_SYNONYMS, sql);
    }

    public void setTableConstraintsColumnsSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.CONSTRAINT_COLUMN_USAGE, sql);
    }

    public void setTableConstraintsSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.TABLE_CONSTRAINTS, sql);
    }

    public void setTriggersSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.TRIGGERS, sql);
    }

    public void setViewsSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.VIEWS, sql);
    }

    public Config toConfig() {
        Config config = new Config();
        for (Map.Entry<InformationSchemaKey, String> sqlEntry : this.informationSchemaQueries.entrySet()) {
            config.put(sqlEntry.getKey().getLookupKey(), sqlEntry.getValue());
        }
        return config;
    }

    public String toString() {
        return ObjectToString.toString(this.informationSchemaQueries);
    }

    protected static enum InformationSchemaKey {
        ADDITIONAL_COLUMN_ATTRIBUTES("select.ADDITIONAL_COLUMN_ATTRIBUTES"),
        ADDITIONAL_TABLE_ATTRIBUTES("select.ADDITIONAL_TABLE_ATTRIBUTES"),
        CONSTRAINT_COLUMN_USAGE("select.INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE"),
        EXT_INDEXES("select.INFORMATION_SCHEMA.EXT_INDEXES"),
        EXT_SYNONYMS("select.INFORMATION_SCHEMA.EXT_SYNONYMS"),
        EXT_TABLES("select.INFORMATION_SCHEMA.EXT_TABLES"),
        EXT_TABLE_CONSTRAINTS("select.INFORMATION_SCHEMA.EXT_TABLE_CONSTRAINTS"),
        OVERRIDE_TYPE_INFO("select.OVERRIDE_TYPE_INFO"),
        ROUTINES("select.INFORMATION_SCHEMA.ROUTINES"),
        SCHEMATA("select.INFORMATION_SCHEMA.SCHEMATA"),
        SEQUENCES("select.INFORMATION_SCHEMA.SEQUENCES"),
        TABLE_CONSTRAINTS("select.INFORMATION_SCHEMA.TABLE_CONSTRAINTS"),
        TRIGGERS("select.INFORMATION_SCHEMA.TRIGGERS"),
        VIEWS("select.INFORMATION_SCHEMA.VIEWS");

        private final String lookupKey;

        private InformationSchemaKey(String lookupKey) {
            this.lookupKey = lookupKey;
        }

        public String getLookupKey() {
            return this.lookupKey;
        }

        public String getResource() {
            return this.name() + ".sql";
        }
    }
}

