/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.base;

import java.awt.Color;
import java.util.logging.Logger;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.SchemaCrawlerInfo;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.TextOutputFormat;
import schemacrawler.tools.text.base.BaseFormatter;
import schemacrawler.tools.text.base.BaseTextOptions;
import schemacrawler.tools.text.utility.Alignment;
import schemacrawler.tools.text.utility.TableCell;
import schemacrawler.tools.text.utility.TableRow;
import sf.util.Utility;

public abstract class BaseDotFormatter<O extends BaseTextOptions>
extends BaseFormatter<O> {
    protected static final Logger LOGGER = Logger.getLogger(BaseDotFormatter.class.getName());

    protected BaseDotFormatter(O options, boolean printVerboseDatabaseInfo, OutputOptions outputOptions) throws SchemaCrawlerException {
        super(options, printVerboseDatabaseInfo, outputOptions);
    }

    @Override
    public void begin() {
        String text = Utility.readResourceFully("/dot.header.txt");
        this.out.println(text);
    }

    @Override
    public void end() {
        this.out.println("}");
        this.out.flush();
        this.out.close();
    }

    @Override
    public void handle(DatabaseInfo dbInfo) {
        if (this.options.isNoInfo() || dbInfo == null) {
            return;
        }
        TableRow row = new TableRow(TextOutputFormat.html);
        row.add(this.newTableCell("Database:", Alignment.right, false, Color.white, 1));
        row.add(this.newTableCell(dbInfo.getProductName() + "  " + dbInfo.getProductVersion(), Alignment.left, false, Color.white, 1));
        this.out.append(row.toString()).append(Utility.NEWLINE);
    }

    @Override
    public void handle(JdbcDriverInfo driverInfo) {
        if (this.options.isNoInfo() || driverInfo == null) {
            return;
        }
        TableRow row = new TableRow(TextOutputFormat.html);
        row.add(this.newTableCell("Driver:", Alignment.right, false, Color.white, 1));
        row.add(this.newTableCell(driverInfo.getDriverName() + "  " + driverInfo.getDriverVersion(), Alignment.left, false, Color.white, 1));
        this.out.append(row.toString()).append(Utility.NEWLINE);
    }

    @Override
    public void handle(SchemaCrawlerInfo schemaCrawlerInfo) {
        if (this.options.isNoInfo() || schemaCrawlerInfo == null) {
            return;
        }
        TableRow row = new TableRow(TextOutputFormat.html);
        row.add(this.newTableCell("Generated by:", Alignment.right, false, Color.white, 1));
        row.add(this.newTableCell(schemaCrawlerInfo.getSchemaCrawlerProductName() + " " + schemaCrawlerInfo.getSchemaCrawlerVersion(), Alignment.left, false, Color.white, 1));
        this.out.append(row.toString()).append(Utility.NEWLINE);
        row = new TableRow(TextOutputFormat.html);
        row.add(this.newTableCell("Generated on:", Alignment.right, false, Color.white, 1));
        row.add(this.newTableCell(schemaCrawlerInfo.getCrawlTimestamp(), Alignment.left, false, Color.white, 1));
        this.out.append(row.toString()).append(Utility.NEWLINE);
    }

    @Override
    public void handleInfoEnd() throws SchemaCrawlerException {
        if (this.options.isNoInfo()) {
            return;
        }
        this.out.append("      </table>    >").append(Utility.NEWLINE).append("    labeljust=r").append(Utility.NEWLINE).append("    labelloc=b").append(Utility.NEWLINE).append("  ];").append(Utility.NEWLINE).append(Utility.NEWLINE);
    }

    @Override
    public void handleInfoStart() throws SchemaCrawlerException {
        if (this.options.isNoInfo()) {
            return;
        }
        this.out.append("  graph [fontcolor=\"#555555\", ").append(Utility.NEWLINE).append("    label=<").append(Utility.NEWLINE).append("<table color=\"#555555\" border=\"1\" cellborder=\"0\" cellspacing=\"0\">").append(Utility.NEWLINE);
    }

    protected TableCell newTableCell(String text, Alignment align, boolean emphasizeText, Color bgColor, int colspan) {
        return new TableCell(text, 0, align, emphasizeText, "", bgColor, colspan, TextOutputFormat.html);
    }
}

