/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.schema;

import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.NamedObjectWithAttributes;
import schemacrawler.schema.Routine;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.analysis.associations.CatalogWithAssociations;
import schemacrawler.tools.integration.graph.GraphOptions;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.TextOutputFormat;
import schemacrawler.tools.text.base.BaseDotFormatter;
import schemacrawler.tools.text.schema.SchemaTextDetailType;
import schemacrawler.tools.text.schema.SchemaTextOptions;
import schemacrawler.tools.text.utility.Alignment;
import schemacrawler.tools.text.utility.TableRow;
import schemacrawler.tools.traversal.SchemaTraversalHandler;
import schemacrawler.utility.MetaDataUtility;
import schemacrawler.utility.NamedObjectSort;
import sf.util.Utility;

public final class SchemaDotFormatter
extends BaseDotFormatter<SchemaTextOptions>
implements SchemaTraversalHandler {
    private final boolean isVerbose;
    private final boolean isBrief;
    private final Map<Schema, Color> colorMap;

    private static Color pastelColorHTMLValue(String text) {
        float hue = Utility.isBlank(text) ? 0.123456f : (float)text.hashCode() / 5119.0f % 1.0f;
        float saturation = 0.4f;
        float luminance = 0.98f;
        Color color = Color.getHSBColor(hue, 0.4f, 0.98f);
        return color;
    }

    public SchemaDotFormatter(SchemaTextDetailType schemaTextDetailType, SchemaTextOptions options, OutputOptions outputOptions) throws SchemaCrawlerException {
        super(options, schemaTextDetailType == SchemaTextDetailType.details, outputOptions);
        this.isVerbose = schemaTextDetailType == SchemaTextDetailType.details;
        this.isBrief = schemaTextDetailType == SchemaTextDetailType.brief;
        this.colorMap = new HashMap<Schema, Color>();
    }

    @Override
    public void handle(ColumnDataType columnDataType) throws SchemaCrawlerException {
    }

    @Override
    public void handle(Routine routine) {
    }

    @Override
    public void handle(Sequence sequence) {
    }

    @Override
    public void handle(Synonym synonym) {
    }

    @Override
    public void handle(Table table) {
        String tableName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? table.getName() : table.getFullName();
        String tableType = "[" + table.getTableType() + "]";
        Color tableNameBgColor = this.getTableNameBgColor(table);
        int colspan = ((SchemaTextOptions)this.options).isShowOrdinalNumbers() ? 3 : 2;
        this.out.append("  /* ").append(table.getFullName()).append(" -=-=-=-=-=-=-=-=-=-=-=-=-=- */").println();
        this.out.append("  \"").append(this.nodeId(table)).append("\" [").println();
        this.out.append("    label=<").println();
        this.out.append("      <table border=\"1\" cellborder=\"0\" cellpadding=\"2\" cellspacing=\"0\" bgcolor=\"white\" color=\"#555555\">").println();
        this.out.append(new TableRow(TextOutputFormat.html).add(this.newTableCell(tableName, Alignment.left, true, tableNameBgColor, colspan)).add(this.newTableCell(tableType, Alignment.right, false, tableNameBgColor, 1)).toString());
        this.out.println();
        this.printTableRemarks(table);
        List<Column> columns = table.getColumns();
        this.printTableColumns(columns);
        this.out.append("      </table>").println();
        this.out.append("    >").println();
        this.out.append("  ];").println();
        this.out.println();
        this.printForeignKeys(table);
        if (this.isVerbose) {
            this.printWeakAssociations(table);
        }
        this.out.println();
        this.out.println();
        this.out.flush();
    }

    @Override
    public void handleColumnDataTypesEnd() {
    }

    @Override
    public void handleColumnDataTypesStart() {
    }

    @Override
    public void handleRoutinesEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleRoutinesStart() throws SchemaCrawlerException {
    }

    @Override
    public void handleSequencesEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleSequencesStart() throws SchemaCrawlerException {
    }

    @Override
    public void handleSynonymsEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleSynonymsStart() throws SchemaCrawlerException {
    }

    @Override
    public void handleTablesEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleTablesStart() throws SchemaCrawlerException {
    }

    private String arrowhead(MetaDataUtility.Connectivity connectivity) {
        switch (connectivity) {
            case unknown: {
                return "box";
            }
            case zero_one: {
                return "teeodot";
            }
            case zero_many: {
                return "crowodot";
            }
            case one_one: {
                return "teetee";
            }
        }
        return "box";
    }

    private String[] getPortIds(Column column) {
        boolean isColumnReference;
        String[] portIds = new String[2];
        try {
            column.getColumnDataType();
            isColumnReference = false;
        }
        catch (Exception e) {
            isColumnReference = true;
        }
        if (!isColumnReference) {
            portIds[0] = String.format("\"%s\":\"%s.start\"", this.nodeId((NamedObjectWithAttributes)column.getParent()), this.nodeId(column));
            portIds[1] = String.format("\"%s\":\"%s.end\"", this.nodeId((NamedObjectWithAttributes)column.getParent()), this.nodeId(column));
        } else {
            String nodeId;
            portIds[0] = nodeId = this.printNewNode(column);
            portIds[1] = nodeId;
        }
        return portIds;
    }

    private Color getTableNameBgColor(Table table) {
        Color tableNameBgColor;
        Schema schema = table.getSchema();
        if (!this.colorMap.containsKey(schema)) {
            tableNameBgColor = SchemaDotFormatter.pastelColorHTMLValue(schema.getFullName());
            this.colorMap.put(schema, tableNameBgColor);
        } else {
            tableNameBgColor = this.colorMap.get(schema);
        }
        return tableNameBgColor;
    }

    private String nodeId(NamedObjectWithAttributes namedObject) {
        if (namedObject == null) {
            return "";
        }
        return Utility.convertForComparison(namedObject.getName()) + "_" + Integer.toHexString(namedObject.getFullName().hashCode());
    }

    private String printColumnReference(String associationName, ColumnReference columnReference, boolean isForeignKeyUnique) {
        Column primaryKeyColumn = columnReference.getPrimaryKeyColumn();
        Column foreignKeyColumn = columnReference.getForeignKeyColumn();
        String[] pkPortIds = this.getPortIds(primaryKeyColumn);
        String[] fkPortIds = this.getPortIds(foreignKeyColumn);
        MetaDataUtility.Connectivity connectivity = MetaDataUtility.getConnectivity(foreignKeyColumn, isForeignKeyUnique);
        GraphOptions graphOptions = (GraphOptions)this.options;
        String pkSymbol = graphOptions.isShowPrimaryKeyCardinality() ? "teetee" : "none";
        String fkSymbol = graphOptions.isShowForeignKeyCardinality() ? this.arrowhead(connectivity) : "none";
        String style = Utility.isBlank(associationName) ? "dashed" : "solid";
        return String.format("  %s:w -> %s:e [label=<%s> style=\"%s\" dir=\"both\" arrowhead=\"%s\" arrowtail=\"%s\"];%n", fkPortIds[0], pkPortIds[1], ((SchemaTextOptions)this.options).isHideForeignKeyNames() ? "" : associationName, style, pkSymbol, fkSymbol);
    }

    private void printForeignKeys(Table table) {
        for (ForeignKey foreignKey : table.getForeignKeys()) {
            boolean isForeignKeyUnique = MetaDataUtility.isForeignKeyUnique(foreignKey, table);
            for (ColumnReference columnReference : foreignKey.getColumnReferences()) {
                if (!table.equals(columnReference.getPrimaryKeyColumn().getParent())) continue;
                this.out.write(this.printColumnReference(foreignKey.getName(), columnReference, isForeignKeyUnique));
            }
        }
    }

    private String printNewNode(Column column) {
        String nodeId = "\"" + this.nodeId(column) + "\"";
        String columnName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? column.getShortName() : column.getFullName();
        String columnNode = String.format("  %s [label=<%s>];%n", nodeId, columnName);
        this.out.write(columnNode);
        return nodeId;
    }

    private void printTableColumnAutoIncremented(Column column) {
        if (column == null || !column.isAutoIncremented()) {
            return;
        }
        TableRow remarksRow = new TableRow(TextOutputFormat.html);
        if (((SchemaTextOptions)this.options).isShowOrdinalNumbers()) {
            remarksRow.add(this.newTableCell("", Alignment.right, false, Color.white, 1));
        }
        remarksRow.add(this.newTableCell("", Alignment.left, false, Color.white, 1)).add(this.newTableCell(" ", Alignment.left, false, Color.white, 1)).add(this.newTableCell("auto-incremented", Alignment.left, false, Color.white, 1));
        this.out.println(remarksRow.toString());
    }

    private void printTableColumnRemarks(Column column) {
        if (column == null || !column.hasRemarks()) {
            return;
        }
        TableRow remarksRow = new TableRow(TextOutputFormat.html);
        if (((SchemaTextOptions)this.options).isShowOrdinalNumbers()) {
            remarksRow.add(this.newTableCell("", Alignment.right, false, Color.white, 1));
        }
        remarksRow.add(this.newTableCell("", Alignment.left, false, Color.white, 1)).add(this.newTableCell(" ", Alignment.left, false, Color.white, 1)).add(this.newTableCell(column.getRemarks(), Alignment.left, false, Color.white, 1));
        this.out.println(remarksRow.toString());
    }

    private void printTableColumns(List<Column> columns) {
        Collections.sort(columns, NamedObjectSort.getNamedObjectSort(((SchemaTextOptions)this.options).isAlphabeticalSortForTableColumns()));
        for (Column column : columns) {
            if (this.isBrief && !this.isColumnSignificant(column)) continue;
            String columnTypeName = ((SchemaTextOptions)this.options).isShowStandardColumnTypeNames() ? column.getColumnDataType().getJavaSqlType().getJavaSqlTypeName() : column.getColumnDataType().getDatabaseSpecificTypeName();
            String columnType = columnTypeName + column.getWidth();
            String nullable = this.columnNullable(columnTypeName, column.isNullable());
            String columnDetails = columnType + nullable;
            boolean emphasize = column.isPartOfPrimaryKey();
            TableRow row = new TableRow(TextOutputFormat.html);
            if (((SchemaTextOptions)this.options).isShowOrdinalNumbers()) {
                String ordinalNumberString = String.valueOf(column.getOrdinalPosition());
                row.add(this.newTableCell(ordinalNumberString, Alignment.right, false, Color.white, 1));
            }
            row.add(this.newTableCell(column.getName(), Alignment.left, emphasize, Color.white, 1)).add(this.newTableCell(" ", Alignment.left, false, Color.white, 1)).add(this.newTableCell(columnDetails, Alignment.left, false, Color.white, 1));
            row.firstCell().addAttribute("port", this.nodeId(column) + ".start");
            row.lastCell().addAttribute("port", this.nodeId(column) + ".end");
            this.out.println(row.toString());
            this.printTableColumnAutoIncremented(column);
            this.printTableColumnRemarks(column);
        }
    }

    private void printTableRemarks(Table table) {
        if (table == null || !table.hasRemarks()) {
            return;
        }
        this.out.append(new TableRow(TextOutputFormat.html).add(this.newTableCell(table.getRemarks(), Alignment.left, false, Color.white, 3)).toString());
        this.out.println();
    }

    private void printWeakAssociations(Table table) {
        Collection<ColumnReference> weakAssociations = CatalogWithAssociations.getWeakAssociations(table);
        for (ColumnReference weakAssociation : weakAssociations) {
            if (!table.equals(weakAssociation.getPrimaryKeyColumn().getParent())) continue;
            this.out.write(this.printColumnReference("", weakAssociation, false));
        }
    }
}

