/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.schema;

import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.Routine;
import schemacrawler.schema.SchemaCrawlerInfo;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.base.BaseFormatter;
import schemacrawler.tools.text.schema.SchemaTextDetailType;
import schemacrawler.tools.text.schema.SchemaTextOptions;
import schemacrawler.tools.text.utility.Alignment;
import schemacrawler.tools.text.utility.TextFormattingHelper;
import schemacrawler.tools.traversal.SchemaTraversalHandler;

final class SchemaListFormatter
extends BaseFormatter<SchemaTextOptions>
implements SchemaTraversalHandler {
    private final boolean isVerbose;

    SchemaListFormatter(SchemaTextDetailType schemaTextDetailType, SchemaTextOptions options, OutputOptions outputOptions) throws SchemaCrawlerException {
        super(options, schemaTextDetailType == SchemaTextDetailType.details, outputOptions);
        this.isVerbose = schemaTextDetailType == SchemaTextDetailType.details;
    }

    @Override
    public void begin() {
        if (!((SchemaTextOptions)this.options).isNoHeader()) {
            this.out.println(this.formattingHelper.createDocumentStart());
        }
    }

    @Override
    public void end() throws SchemaCrawlerException {
        if (!((SchemaTextOptions)this.options).isNoFooter()) {
            this.out.println(this.formattingHelper.createDocumentEnd());
        }
        this.out.close();
    }

    @Override
    public void handle(ColumnDataType columnDataType) throws SchemaCrawlerException {
        if (this.printVerboseDatabaseInfo && this.isVerbose) {
            String databaseSpecificTypeName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? columnDataType.getName() : columnDataType.getFullName();
            this.out.println(this.formattingHelper.createNameRow(databaseSpecificTypeName, "[data type]"));
        }
    }

    @Override
    public final void handle(DatabaseInfo dbInfo) {
        if (((SchemaTextOptions)this.options).isNoInfo() || dbInfo == null) {
            return;
        }
        this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.section, "Database Information"));
        this.out.print(this.formattingHelper.createObjectStart(""));
        this.out.println(this.formattingHelper.createNameValueRow("database product name", dbInfo.getProductName(), Alignment.inherit));
        this.out.println(this.formattingHelper.createNameValueRow("database product version", dbInfo.getProductVersion(), Alignment.inherit));
        this.out.println(this.formattingHelper.createNameValueRow("database user name", dbInfo.getUserName(), Alignment.inherit));
        this.out.print(this.formattingHelper.createObjectEnd());
        this.out.flush();
    }

    @Override
    public void handle(JdbcDriverInfo driverInfo) {
        if (((SchemaTextOptions)this.options).isNoInfo() || driverInfo == null) {
            return;
        }
        this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.section, "JDBC Driver Information"));
        this.out.print(this.formattingHelper.createObjectStart(""));
        this.out.println(this.formattingHelper.createNameValueRow("driver name", driverInfo.getDriverName(), Alignment.inherit));
        this.out.println(this.formattingHelper.createNameValueRow("driver version", driverInfo.getDriverVersion(), Alignment.inherit));
        this.out.println(this.formattingHelper.createNameValueRow("driver class name", driverInfo.getDriverClassName(), Alignment.inherit));
        this.out.println(this.formattingHelper.createNameValueRow("url", driverInfo.getConnectionUrl(), Alignment.inherit));
        this.out.print(this.formattingHelper.createObjectEnd());
        this.out.flush();
    }

    @Override
    public void handle(Routine routine) {
        String routineTypeDetail = String.format("%s, %s", new Object[]{routine.getRoutineType(), routine.getReturnType()});
        String routineName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? routine.getName() : routine.getFullName();
        String routineType = "[" + routineTypeDetail + "]";
        this.out.println(this.formattingHelper.createNameRow(routineName, routineType));
        this.printRemarks(routine);
        this.out.flush();
    }

    @Override
    public void handle(SchemaCrawlerInfo schemaCrawlerInfo) {
        if (((SchemaTextOptions)this.options).isNoInfo() || schemaCrawlerInfo == null) {
            return;
        }
        this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.section, "SchemaCrawler Information"));
        this.out.print(this.formattingHelper.createObjectStart(""));
        this.out.println(this.formattingHelper.createNameValueRow("product name", schemaCrawlerInfo.getSchemaCrawlerProductName(), Alignment.inherit));
        this.out.println(this.formattingHelper.createNameValueRow("product version", schemaCrawlerInfo.getSchemaCrawlerVersion(), Alignment.inherit));
        this.out.print(this.formattingHelper.createObjectEnd());
        this.out.flush();
    }

    @Override
    public void handle(Sequence sequence) {
        String sequenceName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? sequence.getName() : sequence.getFullName();
        String sequenceType = "[sequence]";
        this.out.println(this.formattingHelper.createNameRow(sequenceName, "[sequence]"));
        this.printRemarks(sequence);
        this.out.flush();
    }

    @Override
    public void handle(Synonym synonym) {
        String synonymName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? synonym.getName() : synonym.getFullName();
        String synonymType = "[synonym]";
        this.out.println(this.formattingHelper.createNameRow(synonymName, "[synonym]"));
        this.printRemarks(synonym);
        this.out.flush();
    }

    @Override
    public void handle(Table table) {
        String tableName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? table.getName() : table.getFullName();
        String tableType = "[" + table.getTableType() + "]";
        this.out.println(this.formattingHelper.createNameRow(tableName, tableType));
        this.printRemarks(table);
        this.out.flush();
    }

    @Override
    public void handleColumnDataTypesEnd() {
        if (this.printVerboseDatabaseInfo && this.isVerbose) {
            this.out.append(this.formattingHelper.createObjectEnd());
        }
    }

    @Override
    public void handleColumnDataTypesStart() {
        if (this.printVerboseDatabaseInfo && this.isVerbose) {
            this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Data Types"));
            this.out.append(this.formattingHelper.createObjectStart(""));
        }
    }

    @Override
    public final void handleInfoEnd() throws SchemaCrawlerException {
    }

    @Override
    public final void handleInfoStart() throws SchemaCrawlerException {
        if (((SchemaTextOptions)this.options).isNoInfo()) {
            return;
        }
        this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "System Information"));
    }

    @Override
    public void handleRoutinesEnd() throws SchemaCrawlerException {
        this.out.println(this.formattingHelper.createObjectEnd());
    }

    @Override
    public void handleRoutinesStart() throws SchemaCrawlerException {
        this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Routines"));
        this.out.println(this.formattingHelper.createObjectStart(""));
    }

    @Override
    public void handleSequencesEnd() throws SchemaCrawlerException {
        this.out.println(this.formattingHelper.createObjectEnd());
    }

    @Override
    public void handleSequencesStart() throws SchemaCrawlerException {
        this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Sequences"));
        this.out.println(this.formattingHelper.createObjectStart(""));
    }

    @Override
    public void handleSynonymsEnd() throws SchemaCrawlerException {
        this.out.println(this.formattingHelper.createObjectEnd());
    }

    @Override
    public void handleSynonymsStart() throws SchemaCrawlerException {
        this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Synonyms"));
        this.out.println(this.formattingHelper.createObjectStart(""));
    }

    @Override
    public void handleTablesEnd() throws SchemaCrawlerException {
        this.out.append(this.formattingHelper.createObjectEnd());
    }

    @Override
    public void handleTablesStart() throws SchemaCrawlerException {
        this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Tables"));
        this.out.println(this.formattingHelper.createObjectStart(""));
    }

    private void printRemarks(DatabaseObject object) {
        if (object == null || !object.hasRemarks()) {
            return;
        }
        this.out.println(this.formattingHelper.createDescriptionRow(object.getRemarks()));
    }
}

