/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.utility;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import schemacrawler.tools.options.TextOutputFormat;
import schemacrawler.tools.text.utility.Alignment;
import schemacrawler.tools.text.utility.Entities;
import sf.util.Utility;

public class TableCell {
    private final TextOutputFormat outputFormat;
    private final String styleClass;
    private final int colSpan;
    private final int characterWidth;
    private final Alignment align;
    private final String text;
    private final Color bgColor;
    private final boolean emphasizeText;
    private final Map<String, String> attributes;

    private static String escapeAndQuoteCsv(String text) {
        int QUOTE = 34;
        int SEPARATOR = 44;
        String value = String.valueOf(text);
        int length = value.length();
        if (length == 0) {
            return "\"\"";
        }
        if (value.indexOf(44) < 0 && value.indexOf(34) < 0) {
            return value;
        }
        StringBuilder sb = new StringBuilder(length);
        sb.append('\"');
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (c == '\"') {
                sb.append('\"').append(c);
                continue;
            }
            sb.append(c);
        }
        sb.append('\"');
        return sb.toString();
    }

    public TableCell(String text, int characterWidth, Alignment align, boolean emphasizeText, String styleClass, Color bgColor, int colSpan, TextOutputFormat outputFormat) {
        this.outputFormat = outputFormat;
        this.colSpan = colSpan;
        this.styleClass = styleClass;
        this.text = text;
        this.characterWidth = characterWidth;
        this.align = align;
        this.bgColor = bgColor;
        this.emphasizeText = emphasizeText;
        this.attributes = new HashMap<String, String>();
    }

    public String addAttribute(String key, String value) {
        return this.attributes.put(key, value);
    }

    public String toString() {
        if (this.outputFormat == TextOutputFormat.html) {
            return this.toHtmlString();
        }
        return this.toPlainTextString();
    }

    protected String getCellTag() {
        return "td";
    }

    private String toHtmlString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<").append(this.getCellTag());
        for (Map.Entry<String, String> attribute : this.attributes.entrySet()) {
            buffer.append(" ").append(attribute.getKey()).append("='").append(attribute.getValue()).append("'");
        }
        if (this.colSpan > 1) {
            buffer.append(" colspan='").append(this.colSpan).append("'");
        }
        if (this.bgColor != null && !this.bgColor.equals(Color.white)) {
            String bgColorHtml = "#" + Integer.toHexString(this.bgColor.getRGB()).substring(2).toUpperCase();
            buffer.append(" bgcolor='").append(bgColorHtml).append("'");
        }
        if (!Utility.isBlank(this.styleClass)) {
            buffer.append(" class='").append(this.styleClass).append("'");
        } else if (this.align != null && this.align != Alignment.inherit) {
            buffer.append(" align='").append((Object)this.align).append("'");
        }
        buffer.append(">");
        if (this.emphasizeText) {
            buffer.append("<b><i>");
        }
        if (this.text == null) {
            buffer.append("NULL");
        } else {
            buffer.append(Entities.XML.escape(String.valueOf(this.text)));
        }
        if (this.emphasizeText) {
            buffer.append("</i></b>");
        }
        buffer.append("</").append(this.getCellTag()).append(">");
        return buffer.toString();
    }

    private String toPlainTextString() {
        String value;
        String string = value = this.text == null ? "NULL" : this.text;
        if (this.outputFormat == TextOutputFormat.csv) {
            return TableCell.escapeAndQuoteCsv(value);
        }
        if (this.outputFormat == TextOutputFormat.tsv) {
            return String.valueOf(value);
        }
        if (this.characterWidth > 0) {
            if (this.align == Alignment.right) {
                return String.format("%" + this.characterWidth + "s", value);
            }
            return String.format("%-" + this.characterWidth + "s", value);
        }
        return value;
    }
}

