/*
 * Decompiled with CFR 0.152.
 */
package sf.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import sf.util.Utility;

public final class DatabaseUtility {
    private static final Logger LOGGER = Logger.getLogger(DatabaseUtility.class.getName());

    public static Statement createStatement(Connection connection) throws SchemaCrawlerException, SQLException {
        if (connection == null) {
            throw new SchemaCrawlerException("No connection provided");
        }
        if (connection.isClosed()) {
            throw new SchemaCrawlerException("Connection is closed");
        }
        return connection.createStatement();
    }

    public static void executeScriptFromResource(String scriptResource, Connection connection) throws SchemaCrawlerException {
        try (Statement statement = DatabaseUtility.createStatement(connection);){
            String sqlScript = Utility.readResourceFully(scriptResource);
            if (!Utility.isBlank(sqlScript)) {
                for (String sql : sqlScript.split(";")) {
                    ResultSet resultSet = DatabaseUtility.executeSql(statement, sql);
                    if (resultSet == null) continue;
                    LOGGER.log(Level.WARNING, "Ignoring results from query: " + sql);
                    resultSet.close();
                }
            }
        }
        catch (SQLException e) {
            System.err.println(e.getMessage());
            LOGGER.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public static ResultSet executeSql(Statement statement, String sql) throws SchemaCrawlerException {
        ResultSet results = null;
        if (statement == null) {
            return results;
        }
        if (Utility.isBlank(sql)) {
            LOGGER.log(Level.FINE, "No SQL provided", new RuntimeException());
            return results;
        }
        try {
            statement.clearWarnings();
            boolean hasResults = statement.execute(sql);
            if (hasResults) {
                results = statement.getResultSet();
            } else {
                int updateCount = statement.getUpdateCount();
                LOGGER.log(Level.FINE, String.format("No results. Update count of %d for query: ", updateCount, sql));
            }
            for (SQLWarning sqlWarning = statement.getWarnings(); sqlWarning != null; sqlWarning = sqlWarning.getNextWarning()) {
                LOGGER.log(Level.INFO, sqlWarning.getMessage(), sqlWarning);
            }
            return results;
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Error executing: " + sql, e);
            return null;
        }
    }

    private DatabaseUtility() {
    }
}

