/*
 * Decompiled with CFR 0.152.
 */
package sf.util.clparser;

import sf.util.clparser.Option;

public final class OptionValue<T>
implements Option<T> {
    private final Option<T> option;
    private final T value;

    public OptionValue(Option<T> option, T value) {
        this.option = option;
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptionValue)) {
            return false;
        }
        OptionValue other = (OptionValue)obj;
        if (this.option == null ? other.option != null : !this.option.equals(other.option)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public T getDefaultValue() {
        return this.option.getDefaultValue();
    }

    @Override
    public String getLongForm() {
        return this.option.getLongForm();
    }

    @Override
    public String getShortForm() {
        return this.option.getShortForm();
    }

    public T getValue() {
        T returnValue = !this.isFound() ? this.getDefaultValue() : this.value;
        return returnValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.option == null ? 0 : this.option.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean hasLongForm() {
        return this.option.hasLongForm();
    }

    @Override
    public boolean hasShortForm() {
        return this.option.hasShortForm();
    }

    public boolean isFound() {
        return this.value != null;
    }

    public String toString() {
        String optionString = this.option.toString() + "=" + this.value;
        return optionString;
    }
}

