SELECT /*+ PARALLEL(AUTO) */
  NULL AS TABLE_CATALOG,
  OWNER AS TABLE_SCHEMA,
  TABLE_NAME,
  DBMS_METADATA.GET_DDL('TABLE',TABLE_NAME,OWNER) AS TABLE_DEFINITION
FROM
  ALL_TABLES
WHERE
  OWNER NOT IN ('CTXSYS', 'DBSNMP', 'DMSYS', 'MDDATA', 'MDSYS', 'OLAPSYS', 'ORDPLUGINS', 'ORDSYS', 'OUTLN', 'SI_INFORMTN_SCHEMA', 'SYS', 'SYSMAN', 'SYSTEM', 'XDB')
  AND OWNER NOT LIKE 'APEX%'
ORDER BY
  TABLE_SCHEMA,
  TABLE_NAME
