/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.xml.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.xml.api.model.OfNamespaceDescriptor;
import com.buschmais.jqassistant.plugin.xml.api.model.SiblingDescriptor;
import com.buschmais.jqassistant.plugin.xml.api.model.XmlAttributeDescriptor;
import com.buschmais.jqassistant.plugin.xml.api.model.XmlCDataDescriptor;
import com.buschmais.jqassistant.plugin.xml.api.model.XmlDescriptor;
import com.buschmais.jqassistant.plugin.xml.api.model.XmlDocumentDescriptor;
import com.buschmais.jqassistant.plugin.xml.api.model.XmlElementDescriptor;
import com.buschmais.jqassistant.plugin.xml.api.model.XmlNamespaceDescriptor;
import com.buschmais.jqassistant.plugin.xml.api.model.XmlTextDescriptor;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlSourceScannerPlugin
extends AbstractScannerPlugin<Source, XmlDocumentDescriptor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlSourceScannerPlugin.class);
    private XMLInputFactory inputFactory;

    public void initialize() {
        this.inputFactory = XMLInputFactory.newInstance();
        this.inputFactory.setProperty("javax.xml.stream.supportDTD", false);
    }

    public boolean accepts(Source item, String path, Scope scope) throws IOException {
        return true;
    }

    public XmlDocumentDescriptor scan(Source item, String path, Scope scope, Scanner scanner) throws IOException {
        XmlDocumentDescriptor documentDescriptor;
        block10: {
            ScannerContext context = scanner.getContext();
            Store store = context.getStore();
            XmlElementDescriptor parentElement = null;
            documentDescriptor = (XmlDocumentDescriptor)context.peek(XmlDocumentDescriptor.class);
            HashMap<String, XmlNamespaceDescriptor> namespaceMappings = new HashMap<String, XmlNamespaceDescriptor>();
            HashMap<XmlElementDescriptor, SiblingDescriptor> siblings = new HashMap<XmlElementDescriptor, SiblingDescriptor>();
            try {
                XMLStreamReader streamReader = this.inputFactory.createXMLStreamReader(item);
                while (streamReader.hasNext()) {
                    int eventType = streamReader.getEventType();
                    switch (eventType) {
                        case 7: {
                            documentDescriptor = this.startDocument(streamReader, documentDescriptor);
                            break;
                        }
                        case 1: {
                            XmlElementDescriptor childElement = this.startElement(streamReader, documentDescriptor, parentElement, namespaceMappings, store);
                            this.addSibling(parentElement, childElement, siblings);
                            parentElement = childElement;
                            break;
                        }
                        case 2: {
                            parentElement.setLastChild((XmlDescriptor)siblings.remove(parentElement));
                            parentElement = this.endElement(streamReader, parentElement, namespaceMappings);
                            break;
                        }
                        case 4: 
                        case 6: {
                            XmlTextDescriptor textDescriptor = this.characters(streamReader, XmlTextDescriptor.class, parentElement, store);
                            this.addSibling(parentElement, textDescriptor, siblings);
                            break;
                        }
                        case 12: {
                            XmlCDataDescriptor cDataDescriptor = this.characters(streamReader, XmlCDataDescriptor.class, parentElement, store);
                            this.addSibling(parentElement, cDataDescriptor, siblings);
                        }
                    }
                    streamReader.next();
                }
                documentDescriptor.setXmlWellFormed(true);
            }
            catch (XMLStreamException e) {
                LOGGER.warn("Cannot parse document '" + path + "': " + e.getMessage());
                if (documentDescriptor == null) break block10;
                documentDescriptor.setXmlWellFormed(false);
            }
        }
        return documentDescriptor;
    }

    private <X extends SiblingDescriptor & XmlDescriptor> void addSibling(XmlElementDescriptor parentElement, X child, Map<XmlElementDescriptor, SiblingDescriptor> siblings) {
        if (child != null) {
            SiblingDescriptor lastSibling = siblings.get(parentElement);
            if (lastSibling == null) {
                if (parentElement != null) {
                    parentElement.setFirstChild(child);
                }
            } else {
                lastSibling.setNextSibling(child);
            }
            siblings.put(parentElement, child);
        }
    }

    private XmlDocumentDescriptor startDocument(XMLStreamReader streamReader, XmlDocumentDescriptor documentDescriptor) {
        documentDescriptor.setXmlVersion(streamReader.getVersion());
        documentDescriptor.setCharacterEncodingScheme(streamReader.getCharacterEncodingScheme());
        documentDescriptor.setStandalone(streamReader.isStandalone());
        documentDescriptor.setLineNumber(streamReader.getLocation().getLineNumber());
        return documentDescriptor;
    }

    private XmlElementDescriptor startElement(XMLStreamReader streamReader, XmlDocumentDescriptor documentDescriptor, XmlElementDescriptor parentElement, Map<String, XmlNamespaceDescriptor> namespaceMappings, Store store) {
        int i;
        XmlElementDescriptor elementDescriptor = (XmlElementDescriptor)store.create(XmlElementDescriptor.class);
        if (parentElement == null) {
            documentDescriptor.setRootElement(elementDescriptor);
        } else {
            elementDescriptor.setParent(parentElement);
        }
        for (i = 0; i < streamReader.getNamespaceCount(); ++i) {
            XmlNamespaceDescriptor namespaceDescriptor = (XmlNamespaceDescriptor)store.create(XmlNamespaceDescriptor.class);
            String prefix = streamReader.getNamespacePrefix(i);
            String uri = streamReader.getNamespaceURI(i);
            if (!Strings.isNullOrEmpty((String)prefix)) {
                namespaceDescriptor.setPrefix(prefix);
                namespaceMappings.put(prefix, namespaceDescriptor);
            }
            namespaceDescriptor.setUri(uri);
            elementDescriptor.getDeclaredNamespaces().add(namespaceDescriptor);
        }
        this.setName(elementDescriptor, streamReader.getLocalName(), streamReader.getPrefix(), namespaceMappings);
        for (i = 0; i < streamReader.getAttributeCount(); ++i) {
            XmlAttributeDescriptor attributeDescriptor = (XmlAttributeDescriptor)store.create(XmlAttributeDescriptor.class);
            this.setName(attributeDescriptor, streamReader.getAttributeLocalName(i), streamReader.getAttributePrefix(i), namespaceMappings);
            attributeDescriptor.setValue(streamReader.getAttributeValue(i));
            elementDescriptor.getAttributes().add(attributeDescriptor);
        }
        elementDescriptor.setLineNumber(streamReader.getLocation().getLineNumber());
        return elementDescriptor;
    }

    private XmlElementDescriptor endElement(XMLStreamReader streamReader, XmlElementDescriptor parentElement, Map<String, XmlNamespaceDescriptor> namespaceMappings) {
        for (int i = 0; i < streamReader.getNamespaceCount(); ++i) {
            String prefix = streamReader.getNamespacePrefix(i);
            if (Strings.isNullOrEmpty((String)prefix)) continue;
            namespaceMappings.remove(prefix);
        }
        return parentElement.getParent();
    }

    private <T extends XmlTextDescriptor> T characters(XMLStreamReader streamReader, Class<T> type, XmlElementDescriptor parentElement, Store store) {
        if (streamReader.hasText()) {
            int start = streamReader.getTextStart();
            int length = streamReader.getTextLength();
            String text = new String(streamReader.getTextCharacters(), start, length).trim();
            if (!Strings.isNullOrEmpty((String)text)) {
                XmlTextDescriptor textDescriptor = (XmlTextDescriptor)store.create(type);
                textDescriptor.setValue(text);
                textDescriptor.setLineNumber(streamReader.getLocation().getLineNumber());
                parentElement.getCharacters().add(textDescriptor);
                return (T)textDescriptor;
            }
        }
        return null;
    }

    private void setName(OfNamespaceDescriptor ofNamespaceDescriptor, String localName, String prefix, Map<String, XmlNamespaceDescriptor> namespaceMappings) {
        ofNamespaceDescriptor.setName(localName);
        if (!Strings.isNullOrEmpty((String)prefix)) {
            XmlNamespaceDescriptor namespaceDescriptor = namespaceMappings.get(prefix);
            ofNamespaceDescriptor.setNamespaceDeclaration(namespaceDescriptor);
        }
    }
}

