/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.yaml.impl.scanner;

import com.buschmais.jqassistant.plugin.yaml.api.model.YAMLDescriptor;
import com.buschmais.jqassistant.plugin.yaml.api.model.YAMLKeyDescriptor;
import com.buschmais.jqassistant.plugin.yaml.impl.scanner.YAMLEmitter;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class ProcessingContext {
    private ArrayDeque<YAMLDescriptor> stackedContext = new ArrayDeque();
    private LinkedList<YAMLEmitter.ParseContext> context = new LinkedList();

    ProcessingContext() {
    }

    public void push(YAMLDescriptor newContext) {
        this.stackedContext.push(newContext);
    }

    public <T extends YAMLDescriptor> T peek() {
        return (T)this.stackedContext.peek();
    }

    public <T extends YAMLDescriptor> T pop() {
        return (T)this.stackedContext.pop();
    }

    public void pushContextEvent(YAMLEmitter.ParseContext event) {
        this.context.push(event);
    }

    public YAMLEmitter.ParseContext getContext() {
        return this.context.peek();
    }

    public boolean isContext(YAMLEmitter.ParseContext ... eventChain) {
        int pathLength = eventChain.length;
        int currentContextDepth = this.context.size();
        boolean result = true;
        if (pathLength <= currentContextDepth) {
            List tail = this.context.subList(0, pathLength);
            for (int i = pathLength - 1; i >= 0; --i) {
                if (eventChain[i] == tail.get(pathLength - 1 - i)) continue;
                result = false;
                break;
            }
        } else {
            result = false;
        }
        return result;
    }

    public void popContextEvent(int elements) {
        for (int i = 0; i < elements; ++i) {
            this.context.pop();
        }
    }

    public String buildNextFQN(String lastElement) {
        StringBuilder builder = new StringBuilder();
        Iterator<YAMLDescriptor> descItr = this.stackedContext.descendingIterator();
        while (descItr.hasNext()) {
            YAMLDescriptor yamld = descItr.next();
            if (!YAMLKeyDescriptor.class.isAssignableFrom(yamld.getClass())) continue;
            YAMLKeyDescriptor keyDescriptor = (YAMLKeyDescriptor)yamld;
            builder.append(keyDescriptor.getName()).append('.');
        }
        String name = builder.append(lastElement).toString();
        return name;
    }
}

