/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.yaml2.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FilePatternMatcher;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import com.buschmais.jqassistant.plugin.yaml2.api.model.YMLDocumentDescriptor;
import com.buschmais.jqassistant.plugin.yaml2.api.model.YMLFileDescriptor;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph.GraphGenerationFailedException;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph.GraphGenerator;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.EventParser;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.StreamNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.api.lowlevel.Parse;
import org.snakeyaml.engine.v2.exceptions.YamlEngineException;

@ScannerPlugin.Requires(value={FileDescriptor.class})
public class YMLFileScannerPlugin
extends AbstractScannerPlugin<FileResource, YMLFileDescriptor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(YMLFileScannerPlugin.class);
    public static final String PROPERTY_INCLUDE = "yaml.file.include";
    public static final String PROPERTY_EXCLUDE = "yaml.file.exclude";
    private FilePatternMatcher filePatternMatcher;
    public static final String YAML_FILE_EXTENSION = ".yaml";
    public static final String YML_FILE_EXTENSION = ".yml";

    protected FilePatternMatcher getFilePatternMatcher() {
        return this.filePatternMatcher;
    }

    protected boolean isFilePatternMatcherActive() {
        return null != this.getFilePatternMatcher();
    }

    protected void configure() {
        String inclusionPattern = this.getStringProperty(PROPERTY_INCLUDE, null);
        String exclusionPattern = this.getStringProperty(PROPERTY_EXCLUDE, null);
        this.configure(inclusionPattern, exclusionPattern);
    }

    protected void configure(String inclusionPattern, String exclusionPattern) {
        LOGGER.debug("YAML2: Including '{}' / Excluding '{}'", (Object)inclusionPattern, (Object)exclusionPattern);
        if (null != inclusionPattern || null != exclusionPattern) {
            this.filePatternMatcher = FilePatternMatcher.builder().include(inclusionPattern).exclude(exclusionPattern).build();
        }
    }

    public boolean accepts(FileResource file, String path, Scope scope) {
        String lowercasePath = path.toLowerCase();
        boolean decision = true;
        decision = this.isFilePatternMatcherActive() ? this.getFilePatternMatcher().accepts(lowercasePath) : lowercasePath.endsWith(YAML_FILE_EXTENSION) || lowercasePath.endsWith(YML_FILE_EXTENSION);
        LOGGER.debug("YAML2: Checking '{}' ('{}') for acceptance: {}", new Object[]{path, lowercasePath, decision});
        return decision;
    }

    public YMLFileDescriptor scan(FileResource item, String path, Scope scope, Scanner scanner) throws IOException {
        ScannerContext context = scanner.getContext();
        LoadSettings settings = LoadSettings.builder().build();
        FileDescriptor fileDescriptor = (FileDescriptor)context.getCurrentDescriptor();
        EventParser eventParser = new EventParser();
        YMLFileDescriptor yamlFileDescriptor = this.handleFileStart(fileDescriptor);
        yamlFileDescriptor.setValid(false);
        try (InputStream in = item.createStream();){
            Parse parser = new Parse(settings);
            Iterable events = parser.parseInputStream(in);
            StreamNode streamNode = eventParser.parse(StreamSupport.stream(events.spliterator(), false));
            Store store = this.getScannerContext().getStore();
            GraphGenerator generator = new GraphGenerator(store);
            Collection<YMLDocumentDescriptor> documents = generator.generate(streamNode);
            documents.forEach(documentDescriptor -> yamlFileDescriptor.getDocuments().add((YMLDocumentDescriptor)documentDescriptor));
            yamlFileDescriptor.setValid(true);
        }
        catch (GraphGenerationFailedException | YamlEngineException e) {
            LOGGER.warn("YAML file '{}' seems to be invalid and will be marked as invalid. Result graph might be incorrect.", (Object)path);
        }
        return yamlFileDescriptor;
    }

    private YMLFileDescriptor handleFileStart(FileDescriptor fileDescriptor) {
        YMLFileDescriptor yamlFileDescriptor = (YMLFileDescriptor)this.getScannerContext().getStore().addDescriptorType((Descriptor)fileDescriptor, YMLFileDescriptor.class, YMLFileDescriptor.class);
        return yamlFileDescriptor;
    }
}

