/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph;

import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.plugin.yaml2.api.model.YMLDescriptor;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph.AnchorCache;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph.Callback;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph.GraphGenerationFailedException;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph.GraphGenerator;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph.NodeProcessor;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.AbstractBaseNode;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.AliasNode;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.BaseNode;
import java.util.Optional;

public class AliasNodeProcessor
implements NodeProcessor<AliasNode, YMLDescriptor> {
    private final Store store;
    private final AnchorCache anchorCache;
    private GraphGenerator generator;

    public AliasNodeProcessor(Store store, GraphGenerator generator, AnchorCache anchorCache) {
        this.store = store;
        this.anchorCache = anchorCache;
        this.generator = generator;
    }

    @Override
    public void process(AliasNode node, Callback<YMLDescriptor> callback, GraphGenerator.Mode mode) {
        BaseNode<?> aliasedNode = Optional.ofNullable(node.getAliasedNode()).orElseThrow(() -> {
            String anchor = node.getAnchorName();
            String message = String.format("Anchor '%s' not found in document", anchor);
            return new GraphGenerationFailedException(message);
        });
        this.generator.traverse(aliasedNode, callback, mode);
    }

    @Override
    public boolean accepts(AbstractBaseNode node) {
        return node.getClass().isAssignableFrom(AliasNode.class);
    }
}

