/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph;

import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.yaml2.api.model.YMLDescriptor;
import com.buschmais.jqassistant.plugin.yaml2.api.model.YMLFirstDescriptor;
import com.buschmais.jqassistant.plugin.yaml2.api.model.YMLIndexable;
import com.buschmais.jqassistant.plugin.yaml2.api.model.YMLItemDescriptor;
import com.buschmais.jqassistant.plugin.yaml2.api.model.YMLLastDescriptor;
import com.buschmais.jqassistant.plugin.yaml2.api.model.YMLMapDescriptor;
import com.buschmais.jqassistant.plugin.yaml2.api.model.YMLScalarDescriptor;
import com.buschmais.jqassistant.plugin.yaml2.api.model.YMLSequenceDescriptor;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph.AliasLinker;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph.AnchorHandler;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph.Callback;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph.GraphGenerator;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph.NodeProcessor;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.AbstractBaseNode;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.AliasNode;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.SequenceNode;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;

class SequenceNodeProcessor
implements NodeProcessor<SequenceNode, YMLSequenceDescriptor> {
    private final Store store;
    private final GraphGenerator generator;
    private final AliasLinker aliasLinker;
    private final AnchorHandler anchorHandler;
    private static Comparator<YMLDescriptor> INDEX_COMPERATOR = (lhs, rhs) -> {
        Integer lhsIndex = ((YMLIndexable)((Object)lhs)).getIndex();
        Integer rhsIndex = ((YMLIndexable)((Object)rhs)).getIndex();
        return Integer.compare(lhsIndex, rhsIndex);
    };
    private final Consumer<YMLDescriptor> addItemDescriptorHandler;

    public SequenceNodeProcessor(Store store, GraphGenerator generator, AnchorHandler anchorHandler, AliasLinker aliasLinker) {
        this.store = store;
        this.generator = generator;
        this.anchorHandler = anchorHandler;
        this.aliasLinker = aliasLinker;
        this.addItemDescriptorHandler = descriptor -> store.addDescriptorType((Descriptor)descriptor, YMLItemDescriptor.class);
    }

    @Override
    public void process(SequenceNode node, Callback<YMLSequenceDescriptor> callback, GraphGenerator.Mode mode) {
        YMLSequenceDescriptor sequenceDescriptor = (YMLSequenceDescriptor)this.store.create(YMLSequenceDescriptor.class);
        node.getIndex().ifPresent(sequenceDescriptor::setIndex);
        Callback<YMLSequenceDescriptor> callbackForSequence = descriptor -> {
            this.addItemDescriptorHandler.accept(descriptor);
            sequenceDescriptor.getSequences().add((YMLSequenceDescriptor)descriptor);
        };
        Callback<YMLMapDescriptor> callbackForMap = descriptor -> {
            this.addItemDescriptorHandler.accept(descriptor);
            sequenceDescriptor.getMaps().add((YMLMapDescriptor)descriptor);
        };
        this.anchorHandler.handleAnchor(node, sequenceDescriptor, mode);
        node.getScalars().forEach(scalarNode -> {
            Callback<YMLScalarDescriptor> callbackForScalar = descriptor -> {
                sequenceDescriptor.getScalars().add((YMLScalarDescriptor)descriptor);
                this.store.addDescriptorType((Descriptor)descriptor, YMLItemDescriptor.class);
                this.addItemDescriptorHandler.accept(descriptor);
            };
            this.generator.traverse((AbstractBaseNode)scalarNode, (Callback<? extends YMLDescriptor>)callbackForScalar, mode);
        });
        node.getMaps().forEach(mapNode -> this.generator.traverse((AbstractBaseNode)mapNode, (Callback<? extends YMLDescriptor>)callbackForMap, mode));
        node.getSequences().forEach(seqNode -> this.generator.traverse((AbstractBaseNode)seqNode, (Callback<? extends YMLDescriptor>)callbackForSequence, mode));
        node.getAliases().forEach(aliasNode -> this.generator.traverse((AbstractBaseNode)aliasNode, (Callback<? extends YMLDescriptor>)this.callbackForAliasNode(sequenceDescriptor, (AliasNode)aliasNode), GraphGenerator.Mode.REFERENCE));
        Optional<? extends YMLDescriptor> first = this.findFirstSequenceItem(sequenceDescriptor);
        Optional<? extends YMLDescriptor> last = this.findLastSequenceItem(sequenceDescriptor);
        last.ifPresent(descriptor -> this.store.addDescriptorType((Descriptor)descriptor, YMLLastDescriptor.class));
        first.ifPresent(descriptor -> this.store.addDescriptorType((Descriptor)descriptor, YMLFirstDescriptor.class));
        callback.created(sequenceDescriptor);
    }

    private Callback<YMLDescriptor> callbackForAliasNode(YMLSequenceDescriptor sequenceDescriptor, AliasNode aliasNode) {
        return descriptor -> {
            YMLIndexable scalarDescriptor = (YMLIndexable)((Object)descriptor);
            aliasNode.getIndex().ifPresent(scalarDescriptor::setIndex);
            this.addItemDescriptorHandler.accept(descriptor);
            if (descriptor instanceof YMLSequenceDescriptor) {
                sequenceDescriptor.getSequences().add((YMLSequenceDescriptor)descriptor);
            } else if (descriptor instanceof YMLMapDescriptor) {
                sequenceDescriptor.getMaps().add((YMLMapDescriptor)descriptor);
            } else if (descriptor instanceof YMLScalarDescriptor) {
                sequenceDescriptor.getScalars().add((YMLScalarDescriptor)descriptor);
            } else {
                String message = "Unsupported descriptor type";
                throw new IllegalStateException(message);
            }
            this.aliasLinker.linkToAnchor(aliasNode, descriptor);
        };
    }

    @Override
    public boolean accepts(AbstractBaseNode node) {
        return node.getClass().isAssignableFrom(SequenceNode.class);
    }

    private Optional<? extends YMLDescriptor> findFirstSequenceItem(YMLSequenceDescriptor sequenceDescriptor) {
        return Stream.of(sequenceDescriptor.getScalars(), sequenceDescriptor.getSequences(), sequenceDescriptor.getMaps()).flatMap(Collection::stream).min(INDEX_COMPERATOR);
    }

    private Optional<? extends YMLDescriptor> findLastSequenceItem(YMLSequenceDescriptor sequenceDescriptor) {
        return Stream.of(sequenceDescriptor.getScalars(), sequenceDescriptor.getSequences(), sequenceDescriptor.getMaps()).flatMap(Collection::stream).max(INDEX_COMPERATOR);
    }
}

