/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.api.bootstrap;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.api.XOManagerFactory;
import com.buschmais.xo.api.bootstrap.XOBootstrapService;
import com.buschmais.xo.api.bootstrap.XOUnit;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;

public final class XO {
    private XO() {
    }

    public static XOManagerFactory<?, ?, ?, ?> createXOManagerFactory(String name) {
        Optional<XOBootstrapService> bootstrapService = XO.getBootstrapService();
        if (bootstrapService.isPresent()) {
            return bootstrapService.get().createXOManagerFactory(name);
        }
        throw new XOException("Cannot bootstrap XO implementation.");
    }

    public static XOManagerFactory<?, ?, ?, ?> createXOManagerFactory(XOUnit xoUnit) {
        Optional<XOBootstrapService> bootstrapService = XO.getBootstrapService();
        if (bootstrapService.isPresent()) {
            return bootstrapService.get().createXOManagerFactory(xoUnit);
        }
        throw new XOException("Cannot bootstrap XO implementation.");
    }

    private static Optional<XOBootstrapService> getBootstrapService() {
        ServiceLoader<XOBootstrapService> serviceLoader = ServiceLoader.load(XOBootstrapService.class);
        return StreamSupport.stream(serviceLoader.spliterator(), false).findFirst();
    }
}

