/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.api.bootstrap;

import com.buschmais.xo.api.ConcurrencyMode;
import com.buschmais.xo.api.Transaction;
import com.buschmais.xo.api.ValidationMode;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class XOUnit {
    private String name;
    private String description;
    private URI uri;
    private Class<?> provider;
    private Set<? extends Class<?>> types = new HashSet();
    private List<? extends Class<?>> instanceListeners = new ArrayList();
    private ValidationMode validationMode;
    private ConcurrencyMode concurrencyMode;
    private boolean clearAfterCompletion;
    private Transaction.TransactionAttribute defaultTransactionAttribute;
    private Properties properties;
    private MappingConfiguration mappingConfiguration;

    private static String $default$name() {
        return "default";
    }

    private static String $default$description() {
        return "The default XO unit.";
    }

    private static ValidationMode $default$validationMode() {
        return ValidationMode.AUTO;
    }

    private static ConcurrencyMode $default$concurrencyMode() {
        return ConcurrencyMode.SINGLETHREADED;
    }

    private static boolean $default$clearAfterCompletion() {
        return true;
    }

    private static Transaction.TransactionAttribute $default$defaultTransactionAttribute() {
        return Transaction.TransactionAttribute.NONE;
    }

    private static Properties $default$properties() {
        return new Properties();
    }

    private static MappingConfiguration $default$mappingConfiguration() {
        return MappingConfiguration.builder().build();
    }

    public static XOUnitBuilder builder() {
        return new XOUnitBuilder();
    }

    public XOUnitBuilder toBuilder() {
        XOUnitBuilder builder = new XOUnitBuilder().name(this.name).description(this.description).uri(this.uri).provider(this.provider).validationMode(this.validationMode).concurrencyMode(this.concurrencyMode).clearAfterCompletion(this.clearAfterCompletion).defaultTransactionAttribute(this.defaultTransactionAttribute).properties(this.properties).mappingConfiguration(this.mappingConfiguration);
        if (this.types != null) {
            builder.types(this.types);
        }
        if (this.instanceListeners != null) {
            builder.instanceListeners(this.instanceListeners);
        }
        return builder;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public URI getUri() {
        return this.uri;
    }

    public Class<?> getProvider() {
        return this.provider;
    }

    public Set<? extends Class<?>> getTypes() {
        return this.types;
    }

    public List<? extends Class<?>> getInstanceListeners() {
        return this.instanceListeners;
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }

    public ConcurrencyMode getConcurrencyMode() {
        return this.concurrencyMode;
    }

    public boolean isClearAfterCompletion() {
        return this.clearAfterCompletion;
    }

    public Transaction.TransactionAttribute getDefaultTransactionAttribute() {
        return this.defaultTransactionAttribute;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public MappingConfiguration getMappingConfiguration() {
        return this.mappingConfiguration;
    }

    private XOUnit() {
        this.name = XOUnit.$default$name();
        this.description = XOUnit.$default$description();
        this.validationMode = XOUnit.$default$validationMode();
        this.concurrencyMode = XOUnit.$default$concurrencyMode();
        this.clearAfterCompletion = XOUnit.$default$clearAfterCompletion();
        this.defaultTransactionAttribute = XOUnit.$default$defaultTransactionAttribute();
        this.properties = XOUnit.$default$properties();
        this.mappingConfiguration = XOUnit.$default$mappingConfiguration();
    }

    private XOUnit(String name, String description, URI uri, Class<?> provider, Set<? extends Class<?>> types, List<? extends Class<?>> instanceListeners, ValidationMode validationMode, ConcurrencyMode concurrencyMode, boolean clearAfterCompletion, Transaction.TransactionAttribute defaultTransactionAttribute, Properties properties, MappingConfiguration mappingConfiguration) {
        this.name = name;
        this.description = description;
        this.uri = uri;
        this.provider = provider;
        this.types = types;
        this.instanceListeners = instanceListeners;
        this.validationMode = validationMode;
        this.concurrencyMode = concurrencyMode;
        this.clearAfterCompletion = clearAfterCompletion;
        this.defaultTransactionAttribute = defaultTransactionAttribute;
        this.properties = properties;
        this.mappingConfiguration = mappingConfiguration;
    }

    public String toString() {
        return "XOUnit(name=" + this.getName() + ", description=" + this.getDescription() + ", uri=" + this.getUri() + ", provider=" + this.getProvider() + ", types=" + this.getTypes() + ", instanceListeners=" + this.getInstanceListeners() + ", validationMode=" + (Object)((Object)this.getValidationMode()) + ", concurrencyMode=" + (Object)((Object)this.getConcurrencyMode()) + ", clearAfterCompletion=" + this.isClearAfterCompletion() + ", defaultTransactionAttribute=" + (Object)((Object)this.getDefaultTransactionAttribute()) + ", properties=" + this.getProperties() + ", mappingConfiguration=" + this.getMappingConfiguration() + ")";
    }

    public static class XOUnitBuilder {
        private boolean name$set;
        private String name$value;
        private boolean description$set;
        private String description$value;
        private URI uri;
        private Class<?> provider;
        private ArrayList<Class<?>> types;
        private ArrayList<Class<?>> instanceListeners;
        private boolean validationMode$set;
        private ValidationMode validationMode$value;
        private boolean concurrencyMode$set;
        private ConcurrencyMode concurrencyMode$value;
        private boolean clearAfterCompletion$set;
        private boolean clearAfterCompletion$value;
        private boolean defaultTransactionAttribute$set;
        private Transaction.TransactionAttribute defaultTransactionAttribute$value;
        private boolean properties$set;
        private Properties properties$value;
        private boolean mappingConfiguration$set;
        private MappingConfiguration mappingConfiguration$value;

        XOUnitBuilder() {
        }

        public XOUnitBuilder name(String name) {
            this.name$value = name;
            this.name$set = true;
            return this;
        }

        public XOUnitBuilder description(String description) {
            this.description$value = description;
            this.description$set = true;
            return this;
        }

        public XOUnitBuilder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public XOUnitBuilder provider(Class<?> provider) {
            this.provider = provider;
            return this;
        }

        public XOUnitBuilder type(Class<?> type) {
            if (this.types == null) {
                this.types = new ArrayList();
            }
            this.types.add(type);
            return this;
        }

        public XOUnitBuilder types(Collection<? extends Class<?>> types) {
            if (this.types == null) {
                this.types = new ArrayList();
            }
            this.types.addAll(types);
            return this;
        }

        public XOUnitBuilder clearTypes() {
            if (this.types != null) {
                this.types.clear();
            }
            return this;
        }

        public XOUnitBuilder instanceListener(Class<?> instanceListener) {
            if (this.instanceListeners == null) {
                this.instanceListeners = new ArrayList();
            }
            this.instanceListeners.add(instanceListener);
            return this;
        }

        public XOUnitBuilder instanceListeners(Collection<? extends Class<?>> instanceListeners) {
            if (this.instanceListeners == null) {
                this.instanceListeners = new ArrayList();
            }
            this.instanceListeners.addAll(instanceListeners);
            return this;
        }

        public XOUnitBuilder clearInstanceListeners() {
            if (this.instanceListeners != null) {
                this.instanceListeners.clear();
            }
            return this;
        }

        public XOUnitBuilder validationMode(ValidationMode validationMode) {
            this.validationMode$value = validationMode;
            this.validationMode$set = true;
            return this;
        }

        public XOUnitBuilder concurrencyMode(ConcurrencyMode concurrencyMode) {
            this.concurrencyMode$value = concurrencyMode;
            this.concurrencyMode$set = true;
            return this;
        }

        public XOUnitBuilder clearAfterCompletion(boolean clearAfterCompletion) {
            this.clearAfterCompletion$value = clearAfterCompletion;
            this.clearAfterCompletion$set = true;
            return this;
        }

        public XOUnitBuilder defaultTransactionAttribute(Transaction.TransactionAttribute defaultTransactionAttribute) {
            this.defaultTransactionAttribute$value = defaultTransactionAttribute;
            this.defaultTransactionAttribute$set = true;
            return this;
        }

        public XOUnitBuilder properties(Properties properties) {
            this.properties$value = properties;
            this.properties$set = true;
            return this;
        }

        public XOUnitBuilder mappingConfiguration(MappingConfiguration mappingConfiguration) {
            this.mappingConfiguration$value = mappingConfiguration;
            this.mappingConfiguration$set = true;
            return this;
        }

        public XOUnit build() {
            List<Object> instanceListeners;
            Set<Object> types;
            switch (this.types == null ? 0 : this.types.size()) {
                case 0: {
                    types = Collections.emptySet();
                    break;
                }
                case 1: {
                    types = Collections.singleton(this.types.get(0));
                    break;
                }
                default: {
                    types = new LinkedHashSet(this.types.size() < 0x40000000 ? 1 + this.types.size() + (this.types.size() - 3) / 3 : Integer.MAX_VALUE);
                    types.addAll(this.types);
                    types = Collections.unmodifiableSet(types);
                }
            }
            switch (this.instanceListeners == null ? 0 : this.instanceListeners.size()) {
                case 0: {
                    instanceListeners = Collections.emptyList();
                    break;
                }
                case 1: {
                    instanceListeners = Collections.singletonList(this.instanceListeners.get(0));
                    break;
                }
                default: {
                    instanceListeners = Collections.unmodifiableList(new ArrayList(this.instanceListeners));
                }
            }
            String name$value = this.name$value;
            if (!this.name$set) {
                name$value = XOUnit.$default$name();
            }
            String description$value = this.description$value;
            if (!this.description$set) {
                description$value = XOUnit.$default$description();
            }
            ValidationMode validationMode$value = this.validationMode$value;
            if (!this.validationMode$set) {
                validationMode$value = XOUnit.$default$validationMode();
            }
            ConcurrencyMode concurrencyMode$value = this.concurrencyMode$value;
            if (!this.concurrencyMode$set) {
                concurrencyMode$value = XOUnit.$default$concurrencyMode();
            }
            boolean clearAfterCompletion$value = this.clearAfterCompletion$value;
            if (!this.clearAfterCompletion$set) {
                clearAfterCompletion$value = XOUnit.$default$clearAfterCompletion();
            }
            Transaction.TransactionAttribute defaultTransactionAttribute$value = this.defaultTransactionAttribute$value;
            if (!this.defaultTransactionAttribute$set) {
                defaultTransactionAttribute$value = XOUnit.$default$defaultTransactionAttribute();
            }
            Properties properties$value = this.properties$value;
            if (!this.properties$set) {
                properties$value = XOUnit.$default$properties();
            }
            MappingConfiguration mappingConfiguration$value = this.mappingConfiguration$value;
            if (!this.mappingConfiguration$set) {
                mappingConfiguration$value = XOUnit.$default$mappingConfiguration();
            }
            return new XOUnit(name$value, description$value, this.uri, this.provider, types, instanceListeners, validationMode$value, concurrencyMode$value, clearAfterCompletion$value, defaultTransactionAttribute$value, properties$value, mappingConfiguration$value);
        }

        public String toString() {
            return "XOUnit.XOUnitBuilder(name$value=" + this.name$value + ", description$value=" + this.description$value + ", uri=" + this.uri + ", provider=" + this.provider + ", types=" + this.types + ", instanceListeners=" + this.instanceListeners + ", validationMode$value=" + (Object)((Object)this.validationMode$value) + ", concurrencyMode$value=" + (Object)((Object)this.concurrencyMode$value) + ", clearAfterCompletion$value=" + this.clearAfterCompletion$value + ", defaultTransactionAttribute$value=" + (Object)((Object)this.defaultTransactionAttribute$value) + ", properties$value=" + this.properties$value + ", mappingConfiguration$value=" + this.mappingConfiguration$value + ")";
        }
    }

    public static class MappingConfiguration {
        private boolean strictValidation;

        private static boolean $default$strictValidation() {
            return false;
        }

        public static MappingConfigurationBuilder builder() {
            return new MappingConfigurationBuilder();
        }

        public boolean isStrictValidation() {
            return this.strictValidation;
        }

        private MappingConfiguration() {
            this.strictValidation = MappingConfiguration.$default$strictValidation();
        }

        private MappingConfiguration(boolean strictValidation) {
            this.strictValidation = strictValidation;
        }

        public String toString() {
            return "XOUnit.MappingConfiguration(strictValidation=" + this.isStrictValidation() + ")";
        }

        public static class MappingConfigurationBuilder {
            private boolean strictValidation$set;
            private boolean strictValidation$value;

            MappingConfigurationBuilder() {
            }

            public MappingConfigurationBuilder strictValidation(boolean strictValidation) {
                this.strictValidation$value = strictValidation;
                this.strictValidation$set = true;
                return this;
            }

            public MappingConfiguration build() {
                boolean strictValidation$value = this.strictValidation$value;
                if (!this.strictValidation$set) {
                    strictValidation$value = MappingConfiguration.$default$strictValidation();
                }
                return new MappingConfiguration(strictValidation$value);
            }

            public String toString() {
                return "XOUnit.MappingConfiguration.MappingConfigurationBuilder(strictValidation$value=" + this.strictValidation$value + ")";
            }
        }
    }
}

