/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.api.metadata.type;

import com.buschmais.xo.api.CompositeObject;
import com.buschmais.xo.api.metadata.type.CompositeType;
import com.buschmais.xo.api.metadata.type.DatastoreTypeMetadata;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class CompositeTypeMetadata<TypeMetadata extends DatastoreTypeMetadata<?>> {
    private final Set<TypeMetadata> metadata;
    private final boolean isFinal;
    private final boolean isAbstract;

    public CompositeTypeMetadata(TypeMetadata ... metadata) {
        this((Set<TypeMetadata>)new HashSet<TypeMetadata>(Arrays.asList(metadata)));
    }

    public CompositeTypeMetadata(Set<TypeMetadata> metadata) {
        this.metadata = Collections.unmodifiableSet(metadata);
        this.isFinal = metadata.stream().anyMatch(typeMetadata -> typeMetadata.isFinal());
        this.isAbstract = metadata.stream().allMatch(typeMetadata -> typeMetadata.isAbstract());
    }

    public Set<TypeMetadata> getMetadata() {
        return this.metadata;
    }

    public CompositeType getCompositeType() {
        CompositeType.Builder builder = CompositeType.builder().type(CompositeObject.class);
        for (DatastoreTypeMetadata typeMetadata : this.metadata) {
            builder.type((Class)typeMetadata.getAnnotatedType().getAnnotatedElement());
        }
        return builder.build();
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public String toString() {
        return "DynamicType{metadata=" + this.metadata + ", isFinal=" + this.isFinal + '}';
    }
}

