/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.api.metadata.type;

import com.buschmais.xo.api.metadata.type.TypeMetadata;
import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;

public class CompositeType {
    private final Class<?>[] classes;
    private final int hashCode;

    CompositeType(Class<?>[] classes) {
        this.classes = classes;
        this.hashCode = Arrays.hashCode(classes);
    }

    public Class<?>[] getClasses() {
        return this.classes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompositeType)) {
            return false;
        }
        CompositeType that = (CompositeType)o;
        return Arrays.equals(this.classes, that.classes);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return Arrays.asList(this.classes).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final SortedSet<Class<?>> types = new TreeSet((type1, type2) -> {
            if (type1.equals(type2)) {
                return 0;
            }
            if (type1.isAssignableFrom((Class<?>)type2)) {
                return 1;
            }
            if (type2.isAssignableFrom((Class<?>)type1)) {
                return -1;
            }
            return type1.getName().compareTo(type2.getName());
        });

        public Builder type(Class<?> type) {
            this.types.add(type);
            return this;
        }

        public Builder types(Class<?>[] types) {
            for (Class<?> type : types) {
                this.types.add(type);
            }
            return this;
        }

        public Builder types(Iterable<Class<?>> types) {
            for (Class<?> type : types) {
                this.types.add(type);
            }
            return this;
        }

        public Builder typeMetadata(TypeMetadata typeMetadata) {
            this.types.add((Class)typeMetadata.getAnnotatedType().getAnnotatedElement());
            return this;
        }

        public CompositeType build() {
            return new CompositeType(this.types.toArray(new Class[this.types.size()]));
        }
    }
}

