/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl;

import com.buschmais.xo.api.ConcurrencyMode;
import com.buschmais.xo.api.Transaction;
import com.buschmais.xo.api.ValidationMode;
import com.buschmais.xo.api.XOException;
import com.buschmais.xo.api.XOManager;
import com.buschmais.xo.api.XOManagerFactory;
import com.buschmais.xo.api.bootstrap.XOUnit;
import com.buschmais.xo.impl.MetadataProvider;
import com.buschmais.xo.impl.SessionContext;
import com.buschmais.xo.impl.XOManagerImpl;
import com.buschmais.xo.impl.metadata.MetadataProviderImpl;
import com.buschmais.xo.impl.plugin.PluginRepositoryManager;
import com.buschmais.xo.impl.plugin.QueryLanguagePluginRepository;
import com.buschmais.xo.spi.bootstrap.XODatastoreProvider;
import com.buschmais.xo.spi.datastore.Datastore;
import com.buschmais.xo.spi.datastore.DatastoreEntityMetadata;
import com.buschmais.xo.spi.datastore.DatastoreRelationMetadata;
import com.buschmais.xo.spi.datastore.DatastoreSession;
import com.buschmais.xo.spi.reflection.ClassHelper;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XOManagerFactoryImpl<EntityId, Entity, EntityMetadata extends DatastoreEntityMetadata<EntityDiscriminator>, EntityDiscriminator, RelationId, Relation, RelationMetadata extends DatastoreRelationMetadata<RelationDiscriminator>, RelationDiscriminator, PropertyMetadata>
implements XOManagerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(XOManagerFactoryImpl.class);
    private final XOUnit xoUnit;
    private final MetadataProvider metadataProvider;
    private final ClassLoader classLoader;
    private final Datastore<?, EntityMetadata, EntityDiscriminator, RelationMetadata, RelationDiscriminator> datastore;
    private final PluginRepositoryManager pluginRepositoryManager;
    private final ValidatorFactory validatorFactory;
    private final ValidationMode validationMode;
    private final ConcurrencyMode concurrencyMode;
    private final Transaction.TransactionAttribute defaultTransactionAttribute;

    public XOManagerFactoryImpl(XOUnit xoUnit) {
        this.xoUnit = xoUnit;
        Class providerType = xoUnit.getProvider();
        if (providerType == null) {
            throw new XOException("No provider specified for XO unit '" + xoUnit.getName() + "'.");
        }
        if (!XODatastoreProvider.class.isAssignableFrom(providerType)) {
            throw new XOException(providerType.getName() + " specified as XO provider must implement " + XODatastoreProvider.class.getName());
        }
        XODatastoreProvider XODatastoreProvider2 = (XODatastoreProvider)XODatastoreProvider.class.cast(ClassHelper.newInstance((Class)providerType));
        this.datastore = XODatastoreProvider2.createDatastore(xoUnit);
        this.pluginRepositoryManager = new PluginRepositoryManager(new QueryLanguagePluginRepository(this.datastore));
        this.validationMode = xoUnit.getValidationMode();
        this.concurrencyMode = xoUnit.getConcurrencyMode();
        this.defaultTransactionAttribute = xoUnit.getDefaultTransactionAttribute();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        final ClassLoader parentClassLoader = contextClassLoader != null ? contextClassLoader : xoUnit.getClass().getClassLoader();
        LOGGER.debug("Using class loader '{}'.", (Object)parentClassLoader.toString());
        this.classLoader = new ClassLoader(){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                return parentClassLoader.loadClass(name);
            }
        };
        this.metadataProvider = new MetadataProviderImpl<EntityMetadata, EntityDiscriminator, RelationMetadata, RelationDiscriminator>(xoUnit.getTypes(), this.datastore);
        this.validatorFactory = this.getValidatorFactory();
        this.datastore.init(this.metadataProvider.getRegisteredMetadata());
    }

    private ValidatorFactory getValidatorFactory() {
        try {
            return Validation.buildDefaultValidatorFactory();
        }
        catch (ValidationException e) {
            LOGGER.debug("No JSR 303 Bean Validation provider available.", (Throwable)e);
            return null;
        }
    }

    public XOManager createXOManager() {
        DatastoreSession datastoreSession = this.datastore.createSession();
        SessionContext sessionContext = new SessionContext(this.metadataProvider, this.pluginRepositoryManager, datastoreSession, this.validatorFactory, this.xoUnit.getInstanceListeners(), this.defaultTransactionAttribute, this.validationMode, this.concurrencyMode, this.classLoader);
        XOManagerImpl xoManager = new XOManagerImpl(sessionContext);
        return (XOManager)sessionContext.getInterceptorFactory().addInterceptor(xoManager, new Class[]{XOManager.class});
    }

    public void close() {
        this.datastore.close();
    }

    public XOUnit getXOUnit() {
        return this.xoUnit;
    }

    public PluginRepositoryManager getPluginRepositoryManager() {
        return this.pluginRepositoryManager;
    }
}

