/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl;

import com.buschmais.xo.api.CompositeObject;
import com.buschmais.xo.api.CompositeType;
import com.buschmais.xo.api.Example;
import com.buschmais.xo.api.Query;
import com.buschmais.xo.api.ResultIterable;
import com.buschmais.xo.api.ResultIterator;
import com.buschmais.xo.api.XOException;
import com.buschmais.xo.api.XOManager;
import com.buschmais.xo.api.XOMigrator;
import com.buschmais.xo.api.XOTransaction;
import com.buschmais.xo.impl.AbstractInstanceManager;
import com.buschmais.xo.impl.AbstractResultIterable;
import com.buschmais.xo.impl.MetadataProvider;
import com.buschmais.xo.impl.SessionContext;
import com.buschmais.xo.impl.XOMigratorImpl;
import com.buschmais.xo.impl.XOSessionImpl;
import com.buschmais.xo.impl.proxy.InstanceInvocationHandler;
import com.buschmais.xo.impl.proxy.example.ExampleProxyMethodService;
import com.buschmais.xo.impl.proxy.repository.RepositoryInvocationHandler;
import com.buschmais.xo.impl.proxy.repository.RepositoryProxyMethodService;
import com.buschmais.xo.impl.query.XOQueryImpl;
import com.buschmais.xo.impl.transaction.TransactionalResultIterator;
import com.buschmais.xo.spi.datastore.DatastoreEntityMetadata;
import com.buschmais.xo.spi.datastore.DatastoreRelationMetadata;
import com.buschmais.xo.spi.datastore.DatastoreSession;
import com.buschmais.xo.spi.datastore.TypeMetadataSet;
import com.buschmais.xo.spi.metadata.CompositeTypeBuilder;
import com.buschmais.xo.spi.metadata.method.AbstractRelationPropertyMethodMetadata;
import com.buschmais.xo.spi.metadata.method.IndexedPropertyMethodMetadata;
import com.buschmais.xo.spi.metadata.method.PrimitivePropertyMethodMetadata;
import com.buschmais.xo.spi.metadata.type.EntityTypeMetadata;
import com.buschmais.xo.spi.metadata.type.RelationTypeMetadata;
import com.buschmais.xo.spi.metadata.type.RepositoryTypeMetadata;
import com.buschmais.xo.spi.metadata.type.SimpleTypeMetadata;
import com.buschmais.xo.spi.metadata.type.TypeMetadata;
import com.buschmais.xo.spi.session.XOSession;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;

public class XOManagerImpl<EntityId, Entity, EntityMetadata extends DatastoreEntityMetadata<EntityDiscriminator>, EntityDiscriminator, RelationId, Relation, RelationMetadata extends DatastoreRelationMetadata<RelationDiscriminator>, RelationDiscriminator, PropertyMetadata>
implements XOManager {
    private final SessionContext<EntityId, Entity, EntityMetadata, EntityDiscriminator, RelationId, Relation, RelationMetadata, RelationDiscriminator, PropertyMetadata> sessionContext;
    private final XOSession<EntityId, Entity, EntityMetadata, EntityDiscriminator, RelationId, Relation, RelationMetadata, RelationDiscriminator, PropertyMetadata> session;
    private final Map<Class<?>, Object> repositories = new HashMap();

    public XOManagerImpl(SessionContext<EntityId, Entity, EntityMetadata, EntityDiscriminator, RelationId, Relation, RelationMetadata, RelationDiscriminator, PropertyMetadata> sessionContext) {
        this.sessionContext = sessionContext;
        this.session = new XOSessionImpl<EntityId, Entity, EntityMetadata, EntityDiscriminator, RelationId, Relation, RelationMetadata, RelationDiscriminator, PropertyMetadata>(sessionContext);
    }

    public XOTransaction currentTransaction() {
        return this.sessionContext.getXOTransaction();
    }

    public Set<ConstraintViolation<Object>> validate() {
        return this.sessionContext.getInstanceValidationService().validate();
    }

    public <T, I> T findById(Class<T> type, I id) {
        TypeMetadata typeMetadata = this.sessionContext.getMetadataProvider().getRegisteredMetadata().get(type);
        if (typeMetadata == null) {
            throw new XOException(type.getName() + " is not a registered type.");
        }
        if (typeMetadata instanceof SimpleTypeMetadata) {
            throw new XOException(type.getName() + " must either be an entity or relation type.");
        }
        if (typeMetadata instanceof EntityTypeMetadata) {
            EntityTypeMetadata entityTypeMetadata = (EntityTypeMetadata)typeMetadata;
            Object entityById = this.sessionContext.getDatastoreSession().getDatastoreEntityManager().findEntityById(entityTypeMetadata, ((DatastoreEntityMetadata)entityTypeMetadata.getDatastoreMetadata()).getDiscriminator(), id);
            return this.sessionContext.getEntityInstanceManager().readInstance(entityById);
        }
        if (typeMetadata instanceof RelationTypeMetadata) {
            RelationTypeMetadata relationTypeMetadata = (RelationTypeMetadata)typeMetadata;
            Object relationById = this.sessionContext.getDatastoreSession().getDatastoreRelationManager().findRelationById(relationTypeMetadata, id);
            return this.sessionContext.getRelationInstanceManager().readInstance(relationById);
        }
        throw new XOException("Unsupported metadata type: " + typeMetadata);
    }

    public <T> ResultIterable<T> find(Class<T> type, Object value) {
        EntityTypeMetadata<EntityMetadata> entityTypeMetadata = this.sessionContext.getMetadataProvider().getEntityMetadata(type);
        IndexedPropertyMethodMetadata indexedProperty = entityTypeMetadata.getIndexedProperty();
        HashMap<PrimitivePropertyMethodMetadata<PropertyMetadata>, Object> exampleEntity = new HashMap<PrimitivePropertyMethodMetadata<PropertyMetadata>, Object>(1);
        if (indexedProperty != null) {
            exampleEntity.put(indexedProperty.getPropertyMethodMetadata(), value);
        } else {
            exampleEntity.put(null, value);
        }
        return this.findByExample(type, exampleEntity);
    }

    public <T> ResultIterable<T> find(Example<T> example, Class<T> type) {
        Map<PrimitivePropertyMethodMetadata<PropertyMetadata>, Object> exampleEntity = this.prepareExample(example, type, new Class[0]);
        return this.findByExample(type, exampleEntity);
    }

    public ResultIterable<CompositeObject> find(Example<CompositeObject> example, Class<?> type, Class<?> ... types) {
        Map<PrimitivePropertyMethodMetadata<PropertyMetadata>, Object> exampleEntity = this.prepareExample(example, type, types);
        return this.findByExample(type, exampleEntity);
    }

    private <T> Map<PrimitivePropertyMethodMetadata<PropertyMetadata>, Object> prepareExample(Example<T> example, Class<?> type, Class<?> ... types) {
        HashMap<PrimitivePropertyMethodMetadata<PropertyMetadata>, Object> exampleEntity = new HashMap<PrimitivePropertyMethodMetadata<PropertyMetadata>, Object>();
        InstanceInvocationHandler invocationHandler = new InstanceInvocationHandler(exampleEntity, new ExampleProxyMethodService<Entity>(type, this.sessionContext));
        ArrayList effectiveTypes = new ArrayList();
        effectiveTypes.add(type);
        effectiveTypes.addAll(Arrays.asList(types));
        CompositeType compositeType = CompositeTypeBuilder.create(CompositeObject.class, type, (Class[])types);
        Object instance = this.sessionContext.getProxyFactory().createInstance(invocationHandler, compositeType);
        example.prepare(instance);
        return exampleEntity;
    }

    private <T> ResultIterable<T> findByExample(Class<?> type, Map<PrimitivePropertyMethodMetadata<PropertyMetadata>, Object> entity) {
        EntityTypeMetadata<EntityMetadata> entityTypeMetadata = this.sessionContext.getMetadataProvider().getEntityMetadata(type);
        Object entityDiscriminator = ((DatastoreEntityMetadata)entityTypeMetadata.getDatastoreMetadata()).getDiscriminator();
        if (entityDiscriminator == null) {
            throw new XOException("Type " + type.getName() + " has no discriminator (i.e. cannot be identified in datastore).");
        }
        final ResultIterator iterator = this.sessionContext.getDatastoreSession().getDatastoreEntityManager().findEntity(entityTypeMetadata, entityDiscriminator, entity);
        final AbstractInstanceManager<EntityId, Entity> entityInstanceManager = this.sessionContext.getEntityInstanceManager();
        ResultIterator resultIterator = new ResultIterator<T>(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public T next() {
                Object entity = iterator.next();
                return entityInstanceManager.readInstance(entity);
            }

            public void remove() {
                throw new UnsupportedOperationException("Cannot remove instance.");
            }

            public void close() {
                iterator.close();
            }
        };
        XOTransaction xoTransaction = this.sessionContext.getXOTransaction();
        Object transactionalIterator = xoTransaction != null ? new TransactionalResultIterator(resultIterator, xoTransaction) : resultIterator;
        return (ResultIterable)this.sessionContext.getInterceptorFactory().addInterceptor((Object)new AbstractResultIterable<T>((ResultIterator)transactionalIterator){
            final /* synthetic */ ResultIterator val$transactionalIterator;
            {
                this.val$transactionalIterator = resultIterator;
            }

            public ResultIterator<T> iterator() {
                return this.val$transactionalIterator;
            }
        }, new Class[]{ResultIterable.class});
    }

    public CompositeObject create(Class<?> type, Class<?> ... types) {
        return this.createByExample(type, types, Collections.emptyMap());
    }

    public CompositeObject create(Example<CompositeObject> example, Class<?> type, Class<?> ... types) {
        Map<PrimitivePropertyMethodMetadata<PropertyMetadata>, Object> exampleEntity = this.prepareExample(example, type, new Class[0]);
        return this.createByExample(type, new Class[0], exampleEntity);
    }

    public <T> T create(Class<T> type) {
        return (T)this.createByExample(type, new Class[0], Collections.emptyMap()).as(type);
    }

    public <T> T create(Example<T> example, Class<T> type) {
        Map<PrimitivePropertyMethodMetadata<PropertyMetadata>, Object> exampleEntity = this.prepareExample(example, type, new Class[0]);
        return (T)this.createByExample(type, new Class[0], exampleEntity).as(type);
    }

    private CompositeObject createByExample(Class<?> type, Class<?>[] types, Map<PrimitivePropertyMethodMetadata<PropertyMetadata>, Object> exampleEntity) {
        TypeMetadataSet<EntityTypeMetadata<EntityMetadata>> effectiveTypes = this.getEffectiveTypes(type, types);
        Set<EntityDiscriminator> entityDiscriminators = this.sessionContext.getMetadataProvider().getEntityDiscriminators(effectiveTypes);
        DatastoreSession<EntityId, Entity, EntityMetadata, EntityDiscriminator, RelationId, Relation, RelationMetadata, RelationDiscriminator, PropertyMetadata> datastoreSession = this.sessionContext.getDatastoreSession();
        Object entity = datastoreSession.getDatastoreEntityManager().createEntity(effectiveTypes, entityDiscriminators, exampleEntity);
        AbstractInstanceManager<EntityId, Entity> entityInstanceManager = this.sessionContext.getEntityInstanceManager();
        CompositeObject instance = (CompositeObject)entityInstanceManager.createInstance(entity);
        this.sessionContext.getInstanceListenerService().postCreate(instance);
        return instance;
    }

    public <S, R, T> R create(S from, Class<R> relationType, T to) {
        return this.createByExample(from, relationType, to, Collections.emptyMap());
    }

    public <S, R, T> R create(Example<R> example, S from, Class<R> relationType, T to) {
        Map<PrimitivePropertyMethodMetadata<PropertyMetadata>, Object> exampleRelation = this.prepareExample(example, relationType, new Class[0]);
        return this.createByExample(from, relationType, to, exampleRelation);
    }

    private <S, R, T> R createByExample(S from, Class<R> relationType, T to, Map<PrimitivePropertyMethodMetadata<PropertyMetadata>, Object> example) {
        MetadataProvider<EntityMetadata, EntityDiscriminator, RelationMetadata, RelationDiscriminator> metadataProvider = this.sessionContext.getMetadataProvider();
        AbstractRelationPropertyMethodMetadata<?> fromProperty = metadataProvider.getPropertyMetadata(from.getClass(), relationType, RelationTypeMetadata.Direction.FROM);
        AbstractRelationPropertyMethodMetadata<?> toProperty = metadataProvider.getPropertyMetadata(to.getClass(), relationType, RelationTypeMetadata.Direction.TO);
        Entity entity = this.sessionContext.getEntityInstanceManager().getDatastoreType(from);
        Object instance = this.sessionContext.getEntityPropertyManager().createRelationReference(entity, fromProperty, to, toProperty, example);
        this.sessionContext.getInstanceListenerService().postCreate(instance);
        return (R)instance;
    }

    public <T> T getRepository(Class<T> repositoryType) {
        Object repository = this.repositories.get(repositoryType);
        if (repository == null) {
            RepositoryProxyMethodService proxyMethodService;
            Object datastoreRepository = this.sessionContext.getDatastoreSession().createRepository(this.session, repositoryType);
            if (repositoryType.isAssignableFrom(datastoreRepository.getClass())) {
                proxyMethodService = new RepositoryProxyMethodService(datastoreRepository, repositoryType);
            } else {
                RepositoryTypeMetadata repositoryMetadata = this.sessionContext.getMetadataProvider().getRepositoryMetadata(repositoryType);
                proxyMethodService = new RepositoryProxyMethodService<Object, Entity, Relation>(datastoreRepository, repositoryMetadata, this.sessionContext);
            }
            RepositoryInvocationHandler invocationHandler = new RepositoryInvocationHandler(proxyMethodService, this);
            Object instance = this.sessionContext.getProxyFactory().createInstance(invocationHandler, CompositeTypeBuilder.create(repositoryType, (Class[])new Class[0]));
            repository = this.sessionContext.getInterceptorFactory().addInterceptor(instance, new Class[]{repositoryType});
            this.repositories.put(repositoryType, repository);
        }
        return (T)repository;
    }

    public <T, Id> Id getId(T instance) {
        AbstractInstanceManager<EntityId, Entity> entityInstanceManager = this.sessionContext.getEntityInstanceManager();
        AbstractInstanceManager<RelationId, Relation> relationInstanceManager = this.sessionContext.getRelationInstanceManager();
        if (entityInstanceManager.isInstance(instance)) {
            Object entity = entityInstanceManager.getDatastoreType(instance);
            return (Id)this.sessionContext.getDatastoreSession().getDatastoreEntityManager().getEntityId(entity);
        }
        if (relationInstanceManager.isInstance(instance)) {
            Object relation = relationInstanceManager.getDatastoreType(instance);
            return (Id)this.sessionContext.getDatastoreSession().getDatastoreRelationManager().getRelationId(relation);
        }
        throw new XOException(instance + " is not a managed XO instance.");
    }

    public <T, M> CompositeObject migrate(T instance, XOManager.MigrationStrategy<T, M> migrationStrategy, Class<M> targetType, Class<?> ... targetTypes) {
        AbstractInstanceManager<EntityId, Entity> entityInstanceManager = this.sessionContext.getEntityInstanceManager();
        Entity entity = entityInstanceManager.getDatastoreType(instance);
        DatastoreSession<EntityId, Entity, EntityMetadata, EntityDiscriminator, RelationId, Relation, RelationMetadata, RelationDiscriminator, PropertyMetadata> datastoreSession = this.sessionContext.getDatastoreSession();
        Set entityDiscriminators = datastoreSession.getDatastoreEntityManager().getEntityDiscriminators(entity);
        MetadataProvider<EntityMetadata, EntityDiscriminator, RelationMetadata, RelationDiscriminator> metadataProvider = this.sessionContext.getMetadataProvider();
        TypeMetadataSet<EntityTypeMetadata<EntityMetadata>> types = metadataProvider.getTypes(entityDiscriminators);
        TypeMetadataSet<EntityTypeMetadata<EntityMetadata>> effectiveTargetTypes = this.getEffectiveTypes(targetType, targetTypes);
        Set<EntityDiscriminator> targetEntityDiscriminators = metadataProvider.getEntityDiscriminators(effectiveTargetTypes);
        datastoreSession.getDatastoreEntityManager().migrateEntity(entity, types, entityDiscriminators, effectiveTargetTypes, targetEntityDiscriminators);
        entityInstanceManager.removeInstance(instance);
        CompositeObject migratedInstance = (CompositeObject)entityInstanceManager.updateInstance(entity);
        if (migrationStrategy != null) {
            migrationStrategy.migrate(instance, migratedInstance.as(targetType));
        }
        entityInstanceManager.closeInstance(instance);
        return migratedInstance;
    }

    public <T, M> CompositeObject migrate(T instance, Class<M> targetType, Class<?> ... targetTypes) {
        return this.migrate(instance, (XOManager.MigrationStrategy<T, M>)null, targetType, targetTypes);
    }

    public <T, M> M migrate(T instance, XOManager.MigrationStrategy<T, M> migrationStrategy, Class<M> targetType) {
        return (M)this.migrate(instance, migrationStrategy, targetType, new Class[0]).as(targetType);
    }

    public <T> XOMigrator<T> migrate(T instance) {
        return (XOMigrator)this.sessionContext.getInterceptorFactory().addInterceptor(new XOMigratorImpl<T, EntityId, Entity, EntityMetadata, EntityDiscriminator>(instance, this.sessionContext), new Class[0]);
    }

    public <T, M> M migrate(T instance, Class<M> targetType) {
        return (M)this.sessionContext.getInterceptorFactory().addInterceptor(this.migrate(instance, (XOManager.MigrationStrategy<T, M>)null, targetType), new Class[0]);
    }

    public <T> void delete(T instance) {
        AbstractInstanceManager<EntityId, Entity> entityInstanceManager = this.sessionContext.getEntityInstanceManager();
        AbstractInstanceManager<RelationId, Relation> relationInstanceManager = this.sessionContext.getRelationInstanceManager();
        DatastoreSession<EntityId, Entity, EntityMetadata, EntityDiscriminator, RelationId, Relation, RelationMetadata, RelationDiscriminator, PropertyMetadata> datastoreSession = this.sessionContext.getDatastoreSession();
        if (entityInstanceManager.isInstance(instance)) {
            Object entity = entityInstanceManager.getDatastoreType(instance);
            this.sessionContext.getInstanceListenerService().preDelete(instance);
            datastoreSession.getDatastoreEntityManager().deleteEntity(entity);
            entityInstanceManager.removeInstance(instance);
            entityInstanceManager.closeInstance(instance);
            this.sessionContext.getInstanceListenerService().postDelete(instance);
        } else if (relationInstanceManager.isInstance(instance)) {
            Object relation = relationInstanceManager.getDatastoreType(instance);
            this.sessionContext.getInstanceListenerService().preDelete(instance);
            datastoreSession.getDatastoreRelationManager().deleteRelation(relation);
            relationInstanceManager.removeInstance(instance);
            relationInstanceManager.closeInstance(instance);
            this.sessionContext.getInstanceListenerService().postDelete(instance);
        } else {
            throw new XOException(instance + " is not a managed XO instance.");
        }
    }

    public Query<Query.Result.CompositeRowObject> createQuery(String query) {
        XOQueryImpl xoQuery = new XOQueryImpl(this.sessionContext, query);
        return (Query)this.sessionContext.getInterceptorFactory().addInterceptor(xoQuery, new Class[]{Query.class});
    }

    public <T> Query<T> createQuery(String query, Class<T> type) {
        XOQueryImpl xoQuery = new XOQueryImpl(this.sessionContext, query, type);
        return (Query)this.sessionContext.getInterceptorFactory().addInterceptor(xoQuery, new Class[]{Query.class});
    }

    public Query<Query.Result.CompositeRowObject> createQuery(String query, Class<?> type, Class<?> ... types) {
        XOQueryImpl xoQuery = new XOQueryImpl(this.sessionContext, query, type, Arrays.asList(types));
        return (Query)this.sessionContext.getInterceptorFactory().addInterceptor(xoQuery, new Class[]{Query.class});
    }

    public <T> Query<T> createQuery(Class<T> query) {
        XOQueryImpl xoQuery = new XOQueryImpl(this.sessionContext, query, query);
        return (Query)this.sessionContext.getInterceptorFactory().addInterceptor(xoQuery, new Class[]{Query.class});
    }

    public <Q> Query<Query.Result.CompositeRowObject> createQuery(Class<Q> query, Class<?> ... types) {
        XOQueryImpl xoQuery = new XOQueryImpl(this.sessionContext, query, query, Arrays.asList(types));
        return (Query)this.sessionContext.getInterceptorFactory().addInterceptor(xoQuery, new Class[]{Query.class});
    }

    public void close() {
        this.sessionContext.getEntityInstanceManager().close();
        this.sessionContext.getRelationInstanceManager().close();
        this.sessionContext.getDatastoreSession().close();
    }

    public <DS> DS getDatastoreSession(Class<DS> sessionType) {
        DatastoreSession<EntityId, Entity, EntityMetadata, EntityDiscriminator, RelationId, Relation, RelationMetadata, RelationDiscriminator, PropertyMetadata> datastoreSession = this.sessionContext.getDatastoreSession();
        return sessionType.cast(datastoreSession);
    }

    public void flush() {
        this.sessionContext.getCacheSynchronizationService().flush();
    }

    public <I> void registerInstanceListener(I instanceListener) {
        this.sessionContext.getInstanceListenerService().registerInstanceListener(instanceListener);
    }

    private TypeMetadataSet<EntityTypeMetadata<EntityMetadata>> getEffectiveTypes(Class<?> type, Class<?> ... types) {
        MetadataProvider<EntityMetadata, EntityDiscriminator, RelationMetadata, RelationDiscriminator> metadataProvider = this.sessionContext.getMetadataProvider();
        TypeMetadataSet effectiveTypes = new TypeMetadataSet();
        effectiveTypes.add(metadataProvider.getEntityMetadata(type));
        for (Class<?> otherType : types) {
            effectiveTypes.add(metadataProvider.getEntityMetadata(otherType));
        }
        return effectiveTypes;
    }
}

