/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl;

import com.buschmais.xo.api.CompositeObject;
import com.buschmais.xo.api.XOMigrator;
import com.buschmais.xo.impl.AbstractInstanceManager;
import com.buschmais.xo.impl.MetadataProvider;
import com.buschmais.xo.impl.SessionContext;
import com.buschmais.xo.spi.datastore.DatastoreEntityManager;
import com.buschmais.xo.spi.datastore.DatastoreEntityMetadata;
import com.buschmais.xo.spi.datastore.DatastoreRelationMetadata;
import com.buschmais.xo.spi.datastore.TypeMetadataSet;
import java.util.HashSet;
import java.util.Set;

public class XOMigratorImpl<T, EntityId, Entity, EntityMetadata extends DatastoreEntityMetadata<EntityDiscriminator>, EntityDiscriminator>
implements XOMigrator<T> {
    private T instance;
    private MetadataProvider<EntityMetadata, EntityDiscriminator, ? extends DatastoreRelationMetadata<?>, ?> metadataProvider;
    private DatastoreEntityManager<EntityId, Entity, EntityMetadata, EntityDiscriminator, ?> datastoreEntityManager;
    private AbstractInstanceManager<EntityId, Entity> entityInstanceManager;

    XOMigratorImpl(T instance, SessionContext<EntityId, Entity, EntityMetadata, EntityDiscriminator, ?, ?, ?, ?, ?> sessionContext) {
        this.instance = instance;
        this.metadataProvider = sessionContext.getMetadataProvider();
        this.datastoreEntityManager = sessionContext.getDatastoreSession().getDatastoreEntityManager();
        this.entityInstanceManager = sessionContext.getEntityInstanceManager();
    }

    public CompositeObject add(Class<?> newType, Class<?> ... newTypes) {
        Set<EntityDiscriminator> newDiscriminators = this.getDiscriminators(newType, newTypes);
        Entity entity = this.invalidateInstance(this.entityInstanceManager);
        Set entityDiscriminators = this.datastoreEntityManager.getEntityDiscriminators(entity);
        newDiscriminators.removeAll(entityDiscriminators);
        this.datastoreEntityManager.addDiscriminators(entity, newDiscriminators);
        return this.createInstance(entity);
    }

    public CompositeObject remove(Class<?> obsoleteType, Class<?> ... obsoleteTypes) {
        Set<EntityDiscriminator> obsoleteDiscriminators = this.getDiscriminators(obsoleteType, obsoleteTypes);
        Entity entity = this.invalidateInstance(this.entityInstanceManager);
        Set entityDiscriminators = this.datastoreEntityManager.getEntityDiscriminators(entity);
        obsoleteDiscriminators.retainAll(entityDiscriminators);
        this.datastoreEntityManager.removeDiscriminators(entity, obsoleteDiscriminators);
        return this.createInstance(entity);
    }

    private Set<EntityDiscriminator> getDiscriminators(Class<?> type, Class<?>[] types) {
        TypeMetadataSet typeMetadata = new TypeMetadataSet();
        typeMetadata.add(this.metadataProvider.getEntityMetadata(type));
        for (Class<?> currentType : types) {
            typeMetadata.add(this.metadataProvider.getEntityMetadata(currentType));
        }
        return new HashSet<EntityDiscriminator>(this.metadataProvider.getEntityDiscriminators(typeMetadata));
    }

    private Entity invalidateInstance(AbstractInstanceManager<EntityId, Entity> entityInstanceManager) {
        Entity entity = entityInstanceManager.getDatastoreType(this.instance);
        entityInstanceManager.removeInstance(this.instance);
        entityInstanceManager.closeInstance(this.instance);
        return entity;
    }

    private CompositeObject createInstance(Entity entity) {
        this.instance = this.entityInstanceManager.createInstance(entity);
        return (CompositeObject)CompositeObject.class.cast(this.instance);
    }
}

