/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl.bootstrap.osgi;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.api.XOManagerFactory;
import com.buschmais.xo.api.bootstrap.XOUnit;
import com.buschmais.xo.api.bootstrap.XOUnitParameter;
import com.buschmais.xo.impl.XOManagerFactoryImpl;
import com.buschmais.xo.impl.bootstrap.osgi.XOUnitConverter;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XOManagerFactoryServiceFactory
implements ManagedServiceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(XOManagerFactoryServiceFactory.class);
    private final Map<String, ServiceRegistration<XOManagerFactory>> serviceInstances = new HashMap<String, ServiceRegistration<XOManagerFactory>>();
    final BundleContext bundleContext;

    public XOManagerFactoryServiceFactory(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public String getName() {
        return "ManagedServiceFactory for XOManagerFactory";
    }

    public void updated(String pid, Dictionary<String, ?> properties) throws ConfigurationException {
        XOUnit xoUnit;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("updated: {}", (Object)pid);
        }
        if (properties == null) {
            return;
        }
        try {
            xoUnit = XOUnitConverter.fromProperties(properties);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("config: {}", (Object)xoUnit);
            }
        }
        catch (XOException e) {
            throw new ConfigurationException(XOUnitParameter.NAME.getKey(), e.getMessage(), (Throwable)e);
        }
        this.deleted(pid);
        XOManagerFactoryImpl xoManagerFactory = new XOManagerFactoryImpl(xoUnit);
        ServiceRegistration registration = this.bundleContext.registerService(XOManagerFactory.class, xoManagerFactory, properties);
        this.serviceInstances.put(pid, (ServiceRegistration<XOManagerFactory>)registration);
    }

    public void deleted(String pid) {
        ServiceRegistration<XOManagerFactory> registration;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("deleted: {}", (Object)pid);
        }
        if ((registration = this.serviceInstances.get(pid)) != null) {
            XOManagerFactory factory = (XOManagerFactory)this.bundleContext.getService(registration.getReference());
            registration.unregister();
            factory.close();
        }
    }

    public void stop() {
        for (String pid : this.serviceInstances.keySet()) {
            this.deleted(pid);
        }
    }
}

