/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl.cache;

import com.buschmais.xo.impl.cache.ReferenceCache;
import com.buschmais.xo.impl.cache.WeakReferenceCache;
import java.util.Collection;

public class TransactionalCache<Id> {
    private final WeakReferenceCache<CacheKey> readCache = new WeakReferenceCache();
    private final ReferenceCache<Id> writeCache = new ReferenceCache();

    public void put(Id id, Object value, Mode mode) {
        if (Mode.WRITE.equals((Object)mode)) {
            this.writeCache.put(id, value);
        }
        this.readCache.put(new CacheKey(id), value);
    }

    public Object get(Id id, Mode mode) {
        Object value = this.writeCache.get(id);
        if (value == null && (value = this.readCache.get(new CacheKey(id))) != null && Mode.WRITE.equals((Object)mode)) {
            this.writeCache.put(id, value);
        }
        return value;
    }

    public void remove(Id id) {
        this.readCache.remove(new CacheKey(id));
        this.writeCache.remove(id);
    }

    public void clear() {
        this.writeCache.clear();
    }

    public Collection<?> readInstances() {
        return this.readCache.values();
    }

    public Collection<?> writtenInstances() {
        return this.writeCache.values();
    }

    public static enum Mode {
        READ,
        WRITE;

    }

    private static class CacheKey<Id> {
        private Id id;

        private CacheKey(Id id) {
            this.id = id;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object obj) {
            return obj != null && this.id.equals(((CacheKey)obj).id);
        }
    }
}

