/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl.metadata;

import com.buschmais.xo.spi.datastore.DatastoreEntityMetadata;
import com.buschmais.xo.spi.datastore.TypeMetadataSet;
import com.buschmais.xo.spi.metadata.type.EntityTypeMetadata;
import com.buschmais.xo.spi.metadata.type.TypeMetadata;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityTypeMetadataResolver<EntityMetadata extends DatastoreEntityMetadata<Discriminator>, Discriminator> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityTypeMetadataResolver.class);
    private final Map<EntityTypeMetadata<EntityMetadata>, Set<Discriminator>> aggregatedDiscriminators = new HashMap<EntityTypeMetadata<EntityMetadata>, Set<Discriminator>>();
    private final Map<Discriminator, Set<EntityTypeMetadata<EntityMetadata>>> typeMetadataByDiscriminator = new HashMap<Discriminator, Set<EntityTypeMetadata<EntityMetadata>>>();

    public EntityTypeMetadataResolver(Map<Class<?>, TypeMetadata> metadataByType) {
        LOGGER.debug("Type metadata = '{}'", metadataByType);
        HashMap<Set<Discriminator>, HashSet<EntityTypeMetadata>> entityMetadataByDiscriminators = new HashMap<Set<Discriminator>, HashSet<EntityTypeMetadata>>();
        for (TypeMetadata typeMetadata : metadataByType.values()) {
            if (!(typeMetadata instanceof EntityTypeMetadata)) continue;
            EntityTypeMetadata entityTypeMetadata = (EntityTypeMetadata)typeMetadata;
            Set<Discriminator> discriminators = this.getAggregatedDiscriminators(entityTypeMetadata);
            HashSet<EntityTypeMetadata> typeMetadataOfDiscriminators = (HashSet<EntityTypeMetadata>)entityMetadataByDiscriminators.get(discriminators);
            if (typeMetadataOfDiscriminators == null) {
                typeMetadataOfDiscriminators = new HashSet<EntityTypeMetadata>();
                entityMetadataByDiscriminators.put(discriminators, typeMetadataOfDiscriminators);
            }
            typeMetadataOfDiscriminators.add(entityTypeMetadata);
            LOGGER.debug("Aggregated discriminators of '{}' = '{}'", (Object)typeMetadata, discriminators);
        }
        for (TypeMetadata typeMetadata : metadataByType.values()) {
            if (!(typeMetadata instanceof EntityTypeMetadata)) continue;
            Set<Discriminator> discriminators = this.aggregatedDiscriminators.get(typeMetadata);
            for (Discriminator discriminator : discriminators) {
                Set<EntityTypeMetadata<EntityMetadata>> entityTypeMetadataOfDiscriminator = this.typeMetadataByDiscriminator.get(discriminator);
                if (entityTypeMetadataOfDiscriminator == null) {
                    entityTypeMetadataOfDiscriminator = new HashSet<EntityTypeMetadata<EntityMetadata>>();
                    this.typeMetadataByDiscriminator.put(discriminator, entityTypeMetadataOfDiscriminator);
                }
                entityTypeMetadataOfDiscriminator.add((EntityTypeMetadata)typeMetadata);
            }
        }
        LOGGER.debug("Type metadata by discriminators: '{}'", this.typeMetadataByDiscriminator);
        for (Map.Entry entry : entityMetadataByDiscriminators.entrySet()) {
            if (((Set)entry.getValue()).size() <= 1) continue;
            LOGGER.info("{} use the same set of discriminators {}.", entry.getValue(), entry.getKey());
        }
    }

    private Set<Discriminator> getAggregatedDiscriminators(EntityTypeMetadata<EntityMetadata> typeMetadata) {
        Set<Discriminator> discriminators = this.aggregatedDiscriminators.get(typeMetadata);
        if (discriminators == null) {
            discriminators = new HashSet<Discriminator>();
            Object discriminator = ((DatastoreEntityMetadata)typeMetadata.getDatastoreMetadata()).getDiscriminator();
            if (discriminator != null) {
                discriminators.add(discriminator);
            }
            for (TypeMetadata superTypeMetadata : typeMetadata.getSuperTypes()) {
                if (!(superTypeMetadata instanceof EntityTypeMetadata)) continue;
                discriminators.addAll(this.getAggregatedDiscriminators((EntityTypeMetadata)superTypeMetadata));
            }
            this.aggregatedDiscriminators.put(typeMetadata, discriminators);
        }
        return discriminators;
    }

    public TypeMetadataSet<EntityTypeMetadata<EntityMetadata>> getTypes(Set<Discriminator> discriminators) {
        TypeMetadataSet allEntityTypeMetadatas = new TypeMetadataSet();
        for (Discriminator discriminator : discriminators) {
            Set<EntityTypeMetadata<EntityMetadata>> entityTypeMetadataOfDiscriminator = this.typeMetadataByDiscriminator.get(discriminator);
            if (entityTypeMetadataOfDiscriminator == null) continue;
            for (EntityTypeMetadata<EntityMetadata> entityTypeMetadata : entityTypeMetadataOfDiscriminator) {
                if (!discriminators.containsAll((Collection)this.aggregatedDiscriminators.get(entityTypeMetadata))) continue;
                allEntityTypeMetadatas.add(entityTypeMetadata);
            }
        }
        return allEntityTypeMetadatas;
    }

    public Set<Discriminator> getDiscriminators(EntityTypeMetadata<EntityMetadata> entityTypeMetadata) {
        Set<Discriminator> discriminators = this.aggregatedDiscriminators.get(entityTypeMetadata);
        return discriminators != null ? discriminators : Collections.emptySet();
    }
}

