/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl.plugin;

import com.buschmais.xo.impl.plugin.PluginRepository;
import com.buschmais.xo.spi.reflection.ClassHelper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPluginRepository<Key, Plugin>
implements PluginRepository<Key, Plugin> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPluginRepository.class);
    private Map<Key, Plugin> plugins = new ConcurrentHashMap<Key, Plugin>();

    @Override
    public Key register(Plugin plugin) {
        Key key = this.getKey(plugin);
        LOGGER.debug("Registering plugin for {}.", key);
        if (key != null) {
            this.plugins.put(key, plugin);
        }
        return key;
    }

    @Override
    public Key register(Class<Plugin> pluginType) {
        return this.register(ClassHelper.newInstance(pluginType));
    }

    @Override
    public void unregister(Key key) {
        LOGGER.debug("Unregistering plugin for {}.", key);
        this.plugins.remove(key);
    }

    @Override
    public Plugin get(Key key) {
        return this.plugins.get(key);
    }

    protected abstract Key getKey(Plugin var1);
}

