/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.api.metadata.type.CompositeTypeMetadata;
import com.buschmais.xo.impl.AbstractInstanceManager;
import com.buschmais.xo.impl.SessionContext;
import com.buschmais.xo.impl.proxy.ProxyMethodService;
import com.buschmais.xo.impl.proxy.relation.RelationProxyMethodService;
import com.buschmais.xo.spi.datastore.DatastoreSession;

public class RelationInstanceManager<Entity, EntityDiscriminator, RelationId, Relation, RelationDiscriminator>
extends AbstractInstanceManager<RelationId, Relation> {
    private final SessionContext<?, Entity, ?, EntityDiscriminator, RelationId, Relation, ?, RelationDiscriminator, ?> sessionContext;
    private final ProxyMethodService<Relation> proxyMethodService;

    public RelationInstanceManager(SessionContext<?, Entity, ?, EntityDiscriminator, RelationId, Relation, ?, RelationDiscriminator, ?> sessionContext) {
        super(sessionContext.getRelationCache(), sessionContext.getInstanceListenerService(), sessionContext.getProxyFactory());
        this.sessionContext = sessionContext;
        this.proxyMethodService = new RelationProxyMethodService<Entity, Relation>(sessionContext);
    }

    @Override
    public boolean isDatastoreType(Object o) {
        return this.sessionContext.getDatastoreSession().getDatastoreRelationManager().isRelation(o);
    }

    public RelationId getDatastoreId(Relation relation) {
        if (relation == null) {
            throw new XOException("No relation provided.");
        }
        return (RelationId)this.sessionContext.getDatastoreSession().getDatastoreRelationManager().getRelationId(relation);
    }

    @Override
    protected CompositeTypeMetadata<?> getTypes(Relation relation) {
        DatastoreSession<?, Entity, ?, EntityDiscriminator, RelationId, Relation, ?, RelationDiscriminator, ?> datastoreSession = this.sessionContext.getDatastoreSession();
        Object source = datastoreSession.getDatastoreRelationManager().getFrom(relation);
        Object target = datastoreSession.getDatastoreRelationManager().getTo(relation);
        Object discriminator = datastoreSession.getDatastoreRelationManager().getRelationDiscriminator(relation);
        if (discriminator == null) {
            throw new XOException("Cannot determine type discriminators for relation '" + relation + "'");
        }
        return this.sessionContext.getMetadataProvider().getRelationTypes(datastoreSession.getDatastoreEntityManager().getEntityDiscriminators(source), discriminator, datastoreSession.getDatastoreEntityManager().getEntityDiscriminators(target));
    }

    @Override
    protected ProxyMethodService<Relation> getProxyMethodService() {
        return this.proxyMethodService;
    }
}

