/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl.bootstrap;

import com.buschmais.xo.api.ConcurrencyMode;
import com.buschmais.xo.api.Transaction;
import com.buschmais.xo.api.ValidationMode;
import com.buschmais.xo.api.XOException;
import com.buschmais.xo.api.bootstrap.XOUnit;
import com.buschmais.xo.impl.bootstrap.XOUnitValidationHandler;
import com.buschmais.xo.impl.schema.v1.ConcurrencyModeType;
import com.buschmais.xo.impl.schema.v1.InstanceListenersType;
import com.buschmais.xo.impl.schema.v1.ObjectFactory;
import com.buschmais.xo.impl.schema.v1.PropertiesType;
import com.buschmais.xo.impl.schema.v1.PropertyType;
import com.buschmais.xo.impl.schema.v1.TransactionAttributeType;
import com.buschmais.xo.impl.schema.v1.ValidationModeType;
import com.buschmais.xo.impl.schema.v1.XOUnitType;
import com.buschmais.xo.impl.schema.v1.Xo;
import com.buschmais.xo.spi.reflection.ClassHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public class XOUnitFactory {
    private static final XOUnitFactory instance = new XOUnitFactory();
    private final JAXBContext xoContext;
    private final Schema xoXsd;

    private XOUnitFactory() {
        try {
            this.xoContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            SchemaFactory xsdFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            this.xoXsd = xsdFactory.newSchema(new StreamSource(XOUnitFactory.class.getResourceAsStream("/META-INF/xsd/xo-1.0.xsd")));
        }
        catch (JAXBException e) {
            throw new XOException("Cannot create JAXBContext for reading xo.xml descriptors.", (Throwable)e);
        }
        catch (SAXException e) {
            throw new XOException("Cannot create Schema for validation of xo.xml descriptors.", (Throwable)e);
        }
    }

    public static XOUnitFactory getInstance() {
        return instance;
    }

    public List<XOUnit> getXOUnits(URL url) throws IOException {
        Xo xo = this.readXODescriptor(url, this.xoXsd);
        return this.getXOUnits(xo);
    }

    private Xo readXODescriptor(URL url, Schema xoXsd) throws IOException {
        try (InputStream is = url.openStream();){
            Unmarshaller unmarshaller = this.xoContext.createUnmarshaller();
            XOUnitValidationHandler validationHandler = new XOUnitValidationHandler();
            unmarshaller.setSchema(xoXsd);
            unmarshaller.setEventHandler((ValidationEventHandler)validationHandler);
            Xo xoXmlContent = (Xo)unmarshaller.unmarshal((Source)new StreamSource(is), Xo.class).getValue();
            if (validationHandler.isValid()) {
                Xo xo = xoXmlContent;
                return xo;
            }
            try {
                throw new XOException("Invalid xo.xml descriptor detected: " + validationHandler.getValidationMessages());
            }
            catch (JAXBException e) {
                throw new XOException("Cannot create JAXB unmarshaller for reading xo.xml descriptors.", (Throwable)e);
            }
        }
    }

    private List<XOUnit> getXOUnits(Xo xo) {
        LinkedList<XOUnit> xoUnits = new LinkedList<XOUnit>();
        for (XOUnitType xoUnitType : xo.getXoUnit()) {
            URI uri;
            String name = xoUnitType.getName();
            String description = xoUnitType.getDescription();
            String urlName = xoUnitType.getUrl();
            try {
                uri = new URI(urlName);
            }
            catch (URISyntaxException e) {
                throw new XOException("Cannot convert '" + urlName + "' to url.", (Throwable)e);
            }
            String providerName = xoUnitType.getProvider();
            Class provider = ClassHelper.getType((String)providerName);
            HashSet<Class> types = new HashSet<Class>();
            for (String typeName : xoUnitType.getTypes().getType()) {
                types.add(ClassHelper.getType((String)typeName));
            }
            ArrayList<Class> instanceListeners = new ArrayList<Class>();
            InstanceListenersType instanceListenersType = xoUnitType.getInstanceListeners();
            if (instanceListenersType != null) {
                for (String instanceListenerName : instanceListenersType.getInstanceListener()) {
                    instanceListeners.add(ClassHelper.getType((String)instanceListenerName));
                }
            }
            ValidationMode validationMode = this.getValidationMode(xoUnitType.getValidationMode());
            ConcurrencyMode concurrencyMode = this.getConcurrencyMode(xoUnitType.getConcurrencyMode());
            Transaction.TransactionAttribute defaultTransactionAttribute = this.getTransactionAttribute(xoUnitType.getDefaultTransactionAttribute());
            Properties properties = new Properties();
            PropertiesType propertiesType = xoUnitType.getProperties();
            if (propertiesType != null) {
                for (PropertyType propertyType : propertiesType.getProperty()) {
                    properties.setProperty(propertyType.getName(), propertyType.getValue());
                }
            }
            XOUnit xoUnit = XOUnit.builder().name(name).description(description).uri(uri).provider(provider).types(types).instanceListeners(instanceListeners).validationMode(validationMode).concurrencyMode(concurrencyMode).defaultTransactionAttribute(defaultTransactionAttribute).properties(properties).build();
            xoUnits.add(xoUnit);
        }
        return xoUnits;
    }

    private ConcurrencyMode getConcurrencyMode(ConcurrencyModeType concurrencyModeType) {
        if (concurrencyModeType == null) {
            return ConcurrencyMode.SINGLETHREADED;
        }
        switch (concurrencyModeType) {
            case SINGLETHREADED: {
                return ConcurrencyMode.SINGLETHREADED;
            }
            case MULTITHREADED: {
                return ConcurrencyMode.MULTITHREADED;
            }
        }
        throw new XOException("Unknown concurrency mode type " + (Object)((Object)concurrencyModeType));
    }

    private ValidationMode getValidationMode(ValidationModeType validationModeType) {
        if (validationModeType == null) {
            return ValidationMode.AUTO;
        }
        switch (validationModeType) {
            case NONE: {
                return ValidationMode.NONE;
            }
            case AUTO: {
                return ValidationMode.AUTO;
            }
        }
        throw new XOException("Unknown validation mode type " + (Object)((Object)validationModeType));
    }

    private Transaction.TransactionAttribute getTransactionAttribute(TransactionAttributeType defaultTransactionAttributeType) {
        if (defaultTransactionAttributeType == null) {
            return Transaction.TransactionAttribute.NONE;
        }
        switch (defaultTransactionAttributeType) {
            case NONE: {
                return Transaction.TransactionAttribute.NONE;
            }
            case MANDATORY: {
                return Transaction.TransactionAttribute.MANDATORY;
            }
            case REQUIRES: {
                return Transaction.TransactionAttribute.REQUIRES;
            }
        }
        throw new XOException("Unknown transaction attribute type " + (Object)((Object)defaultTransactionAttributeType));
    }
}

