/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl.interceptor;

import com.buschmais.xo.api.Transaction;
import com.buschmais.xo.api.XOException;
import com.buschmais.xo.api.XOTransaction;
import com.buschmais.xo.spi.interceptor.InvocationContext;
import com.buschmais.xo.spi.interceptor.XOInterceptor;
import java.lang.reflect.Method;

public class TransactionInterceptor
implements XOInterceptor {
    private final XOTransaction xoTransaction;
    private final Transaction.TransactionAttribute defaultTransactionAttribute;

    public TransactionInterceptor(XOTransaction xoTransaction, Transaction.TransactionAttribute defaultTransactionAttribute) {
        this.xoTransaction = xoTransaction;
        this.defaultTransactionAttribute = defaultTransactionAttribute;
    }

    public boolean isActive() {
        return !Transaction.TransactionAttribute.NONE.equals((Object)this.defaultTransactionAttribute);
    }

    public Object invoke(InvocationContext context) throws Throwable {
        Method method = context.getMethod();
        Transaction transaction = method.getAnnotation(Transaction.class);
        Transaction.TransactionAttribute transactionAttribute = transaction != null ? transaction.value() : this.defaultTransactionAttribute;
        switch (transactionAttribute) {
            case MANDATORY: {
                if (!this.xoTransaction.isActive()) {
                    throw new XOException("An active transaction is MANDATORY when calling method '" + method.getDeclaringClass().getName() + "#" + method.getName() + "'");
                }
                return context.proceed();
            }
            case REQUIRES: {
                if (!this.xoTransaction.isActive()) {
                    try {
                        this.xoTransaction.begin();
                        Object result = context.proceed();
                        this.xoTransaction.commit();
                        return result;
                    }
                    catch (RuntimeException e) {
                        if (this.xoTransaction.isActive()) {
                            this.xoTransaction.rollback();
                        }
                        throw e;
                    }
                    catch (Exception e) {
                        if (this.xoTransaction.isActive()) {
                            this.xoTransaction.commit();
                        }
                        throw e;
                    }
                }
                return context.proceed();
            }
            case NOT_SUPPORTED: {
                return context.proceed();
            }
        }
        throw new XOException("Unsupported transaction attribute '" + transactionAttribute + "'");
    }
}

