/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl.proxy.common.property;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.api.metadata.method.PrimitivePropertyMethodMetadata;
import com.buschmais.xo.api.metadata.reflection.PropertyMethod;
import com.buschmais.xo.impl.AbstractPropertyManager;
import com.buschmais.xo.impl.proxy.common.property.AbstractPropertyMethod;
import java.lang.reflect.Array;
import java.util.Collection;

public abstract class AbstractPrimitivePropertyGetMethod<DatastoreType, PropertyManager extends AbstractPropertyManager<DatastoreType>>
extends AbstractPropertyMethod<DatastoreType, PropertyManager, PrimitivePropertyMethodMetadata> {
    public AbstractPrimitivePropertyGetMethod(PropertyManager propertyManager, PrimitivePropertyMethodMetadata metadata) {
        super(propertyManager, metadata);
    }

    public Object invoke(DatastoreType datastoreType, Object instance, Object[] args) {
        PrimitivePropertyMethodMetadata metadata = (PrimitivePropertyMethodMetadata)this.getMetadata();
        Object propertyManager = this.getPropertyManager();
        Object value = !((AbstractPropertyManager)propertyManager).hasProperty(datastoreType, metadata) ? null : ((AbstractPropertyManager)propertyManager).getProperty(datastoreType, metadata);
        return this.convert(value, ((PropertyMethod)metadata.getAnnotatedMethod()).getType());
    }

    private Object convert(Object value, Class<?> propertyType) {
        if (value != null) {
            if (propertyType.isAssignableFrom(value.getClass())) {
                return value;
            }
            if (Enum.class.isAssignableFrom(propertyType)) {
                return Enum.valueOf(propertyType, (String)value);
            }
            if (propertyType.isArray()) {
                if (Collection.class.isAssignableFrom(value.getClass())) {
                    return this.toArray((Collection)value, propertyType.getComponentType());
                }
            } else if (propertyType.isPrimitive()) {
                return this.convertPrimitive(value, propertyType);
            }
            throw new XOException("Cannot convert value of type " + value.getClass() + " to type " + propertyType);
        }
        if (Boolean.TYPE.equals(propertyType)) {
            return false;
        }
        if (Short.TYPE.equals(propertyType)) {
            return 0;
        }
        if (Integer.TYPE.equals(propertyType)) {
            return 0;
        }
        if (Long.TYPE.equals(propertyType)) {
            return 0L;
        }
        if (Float.TYPE.equals(propertyType)) {
            return Float.valueOf(0.0f);
        }
        if (Double.TYPE.equals(propertyType)) {
            return 0.0;
        }
        if (Character.TYPE.equals(propertyType)) {
            return 0;
        }
        if (Byte.TYPE.equals(propertyType)) {
            return 0;
        }
        return null;
    }

    private Object toArray(Collection<?> values, Class<?> componentType) {
        Object array = Array.newInstance(componentType, values.size());
        int index = 0;
        for (Object value : values) {
            Array.set(array, index, this.convert(value, componentType));
            ++index;
        }
        return array;
    }

    private Object convertPrimitive(Object value, Class<?> propertyType) {
        if (Number.class.isAssignableFrom(value.getClass())) {
            Number number = (Number)value;
            if (Byte.TYPE.equals(propertyType)) {
                return number.byteValue();
            }
            if (Short.TYPE.equals(propertyType)) {
                return number.shortValue();
            }
            if (Integer.TYPE.equals(propertyType)) {
                return number.intValue();
            }
            if (Long.TYPE.equals(propertyType)) {
                return number.longValue();
            }
            if (Float.TYPE.equals(propertyType)) {
                return Float.valueOf(number.floatValue());
            }
            if (Double.TYPE.equals(propertyType)) {
                return number.doubleValue();
            }
        } else if (String.class.isAssignableFrom(value.getClass()) && (Character.class.equals(propertyType) || Character.TYPE.equals(propertyType))) {
            return Character.valueOf(((String)value).charAt(0));
        }
        return value;
    }
}

