/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl;

import com.buschmais.xo.api.CompositeObject;
import com.buschmais.xo.api.XOException;
import com.buschmais.xo.api.metadata.type.CompositeTypeMetadata;
import com.buschmais.xo.impl.ProxyFactory;
import com.buschmais.xo.impl.cache.TransactionalCache;
import com.buschmais.xo.impl.instancelistener.InstanceListenerService;
import com.buschmais.xo.impl.proxy.InstanceInvocationHandler;
import com.buschmais.xo.impl.proxy.ProxyMethodService;
import com.buschmais.xo.spi.session.InstanceManager;

public abstract class AbstractInstanceManager<DatastoreId, DatastoreType>
implements InstanceManager<DatastoreId, DatastoreType> {
    private final TransactionalCache<DatastoreId> cache;
    private final InstanceListenerService instanceListenerService;
    private final ProxyFactory proxyFactory;
    private final ProxyMethodService<DatastoreType> proxyMethodService;

    public <T> T readInstance(DatastoreType datastoreType) {
        return this.getInstance(datastoreType, TransactionalCache.Mode.READ);
    }

    public <T> T createInstance(DatastoreType datastoreType, CompositeTypeMetadata<?> types) {
        return this.newInstance(this.getDatastoreId(datastoreType), datastoreType, types, TransactionalCache.Mode.WRITE);
    }

    public <T> T updateInstance(DatastoreType datastoreType) {
        return this.getInstance(datastoreType, TransactionalCache.Mode.WRITE);
    }

    private <T> T getInstance(DatastoreType datastoreType, TransactionalCache.Mode cacheMode) {
        Object id = this.getDatastoreId(datastoreType);
        Object instance = this.cache.get(id, cacheMode);
        if (instance == null) {
            CompositeTypeMetadata<?> types = this.getTypes(datastoreType);
            instance = this.newInstance(id, datastoreType, types, cacheMode);
            if (TransactionalCache.Mode.READ.equals((Object)cacheMode)) {
                this.instanceListenerService.postLoad(instance);
            }
        }
        return (T)instance;
    }

    private <T> T newInstance(DatastoreId id, DatastoreType datastoreType, CompositeTypeMetadata<?> types, TransactionalCache.Mode cacheMode) {
        this.validateType(types);
        InstanceInvocationHandler<DatastoreType> invocationHandler = new InstanceInvocationHandler<DatastoreType>(datastoreType, this.proxyMethodService);
        Object instance = this.proxyFactory.createInstance(invocationHandler, types.getCompositeType());
        this.cache.put(id, instance, cacheMode);
        return (T)instance;
    }

    private void validateType(CompositeTypeMetadata<?> compositeTypeMetadata) {
        int size = compositeTypeMetadata.getMetadata().size();
        if (size == 1) {
            if (compositeTypeMetadata.isAbstract()) {
                throw new XOException("Cannot create an instance of a single abstract type " + compositeTypeMetadata);
            }
        } else if (compositeTypeMetadata.isFinal()) {
            throw new XOException("Cannot create an instance overriding a final type " + compositeTypeMetadata);
        }
    }

    public <Instance> void removeInstance(Instance instance) {
        DatastoreType datastoreType = this.getDatastoreType(instance);
        Object id = this.getDatastoreId(datastoreType);
        this.cache.remove(id);
    }

    public <Instance> void closeInstance(Instance instance) {
        this.proxyFactory.getInvocationHandler(instance).close();
    }

    public <Instance> boolean isInstance(Instance instance) {
        if (instance instanceof CompositeObject) {
            Object delegate = ((CompositeObject)instance).getDelegate();
            return this.isDatastoreType(delegate);
        }
        return false;
    }

    public <Instance> DatastoreType getDatastoreType(Instance instance) {
        InstanceInvocationHandler invocationHandler = this.proxyFactory.getInvocationHandler(instance);
        return invocationHandler.getDatastoreType();
    }

    public void close() {
        for (Object instance : this.cache.readInstances()) {
            this.closeInstance(instance);
        }
    }

    protected abstract boolean isDatastoreType(Object var1);

    protected abstract CompositeTypeMetadata<?> getTypes(DatastoreType var1);

    public AbstractInstanceManager(TransactionalCache<DatastoreId> cache, InstanceListenerService instanceListenerService, ProxyFactory proxyFactory, ProxyMethodService<DatastoreType> proxyMethodService) {
        this.cache = cache;
        this.instanceListenerService = instanceListenerService;
        this.proxyFactory = proxyFactory;
        this.proxyMethodService = proxyMethodService;
    }
}

