/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl;

import com.buschmais.xo.api.metadata.method.PrimitivePropertyMethodMetadata;
import com.buschmais.xo.api.metadata.method.TransientPropertyMethodMetadata;
import com.buschmais.xo.api.metadata.reflection.PropertyMethod;
import com.buschmais.xo.impl.AbstractInstanceManager;
import com.buschmais.xo.spi.datastore.DatastorePropertyManager;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public abstract class AbstractPropertyManager<DatastoreType> {
    private Map<DatastoreType, Map<String, Object>> transientInstances = null;

    public void setProperty(DatastoreType datastoreType, PrimitivePropertyMethodMetadata metadata, Object value) {
        this.getDatastorePropertyManager().setProperty(datastoreType, metadata, value);
        this.getInstanceManager().updateInstance(datastoreType);
    }

    public Object getProperty(DatastoreType datastoreType, PrimitivePropertyMethodMetadata metadata) {
        return this.getDatastorePropertyManager().getProperty(datastoreType, metadata);
    }

    public boolean hasProperty(DatastoreType datastoreType, PrimitivePropertyMethodMetadata metadata) {
        return this.getDatastorePropertyManager().hasProperty(datastoreType, metadata);
    }

    public void removeProperty(DatastoreType datastoreType, PrimitivePropertyMethodMetadata metadata) {
        this.getDatastorePropertyManager().removeProperty(datastoreType, metadata);
        this.getInstanceManager().updateInstance(datastoreType);
    }

    public void setTransientProperty(DatastoreType datastoreType, TransientPropertyMethodMetadata metadata, Object value) {
        this.getTransientProperties(datastoreType).put(((PropertyMethod)metadata.getAnnotatedMethod()).getName(), value);
    }

    public Object getTransientProperty(DatastoreType datastoreType, TransientPropertyMethodMetadata metadata) {
        return this.getTransientProperties(datastoreType).get(((PropertyMethod)metadata.getAnnotatedMethod()).getName());
    }

    protected abstract DatastorePropertyManager<DatastoreType, ?> getDatastorePropertyManager();

    protected abstract AbstractInstanceManager<?, DatastoreType> getInstanceManager();

    private Map<String, Object> getTransientProperties(DatastoreType datastoreType) {
        if (this.transientInstances == null) {
            this.transientInstances = new IdentityHashMap<DatastoreType, Map<String, Object>>();
        }
        return this.transientInstances.computeIfAbsent(datastoreType, k -> new HashMap());
    }
}

