/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl;

import com.buschmais.xo.api.CloseListener;
import com.buschmais.xo.api.ValidationMode;
import com.buschmais.xo.api.XOException;
import com.buschmais.xo.api.XOManager;
import com.buschmais.xo.api.XOManagerFactory;
import com.buschmais.xo.api.bootstrap.XOUnit;
import com.buschmais.xo.api.metadata.MetadataProvider;
import com.buschmais.xo.api.metadata.type.DatastoreEntityMetadata;
import com.buschmais.xo.api.metadata.type.DatastoreRelationMetadata;
import com.buschmais.xo.impl.DefaultCloseSupport;
import com.buschmais.xo.impl.SessionContext;
import com.buschmais.xo.impl.XOManagerImpl;
import com.buschmais.xo.impl.metadata.MetadataProviderImpl;
import com.buschmais.xo.impl.plugin.PluginRepositoryManager;
import com.buschmais.xo.impl.plugin.QueryLanguagePluginRepository;
import com.buschmais.xo.spi.bootstrap.XODatastoreProvider;
import com.buschmais.xo.spi.datastore.Datastore;
import com.buschmais.xo.spi.datastore.DatastoreSession;
import com.buschmais.xo.spi.reflection.ClassHelper;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XOManagerFactoryImpl<EntityId, Entity, EntityMetadata extends DatastoreEntityMetadata<EntityDiscriminator>, EntityDiscriminator, RelationId, Relation, RelationMetadata extends DatastoreRelationMetadata<RelationDiscriminator>, RelationDiscriminator, PropertyMetadata>
implements XOManagerFactory<EntityMetadata, EntityDiscriminator, RelationMetadata, RelationDiscriminator> {
    private static final Logger LOGGER = LoggerFactory.getLogger(XOManagerFactoryImpl.class);
    private final XOUnit xoUnit;
    private final MetadataProvider metadataProvider;
    private final ClassLoader classLoader;
    private final Datastore<?, EntityMetadata, EntityDiscriminator, RelationMetadata, RelationDiscriminator> datastore;
    private final PluginRepositoryManager pluginRepositoryManager;
    private final ValidatorFactory validatorFactory;
    private final DefaultCloseSupport closeSupport = new DefaultCloseSupport();

    public XOManagerFactoryImpl(XOUnit xoUnit) {
        this.xoUnit = xoUnit;
        Class providerType = xoUnit.getProvider();
        if (providerType == null) {
            throw new XOException("No provider specified for XO unit '" + xoUnit.getName() + "'.");
        }
        if (!XODatastoreProvider.class.isAssignableFrom(providerType)) {
            throw new XOException(providerType.getName() + " specified as XO provider must implement " + XODatastoreProvider.class.getName());
        }
        XODatastoreProvider xoDatastoreProvider = (XODatastoreProvider)XODatastoreProvider.class.cast(ClassHelper.newInstance((Class)providerType));
        this.datastore = xoDatastoreProvider.createDatastore(xoUnit);
        this.pluginRepositoryManager = new PluginRepositoryManager(new QueryLanguagePluginRepository(this.datastore));
        this.classLoader = xoUnit.getClassLoader().orElseGet(() -> {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            return contextClassLoader != null ? contextClassLoader : xoUnit.getClass().getClassLoader();
        });
        LOGGER.debug("Using class loader '{}'.", (Object)this.classLoader);
        this.metadataProvider = new MetadataProviderImpl<EntityMetadata, EntityDiscriminator, RelationMetadata, RelationDiscriminator>(xoUnit.getTypes(), this.datastore, xoUnit.getMappingConfiguration());
        this.validatorFactory = this.getValidatorFactory();
        this.datastore.init(this.metadataProvider.getRegisteredMetadata());
    }

    private ValidatorFactory getValidatorFactory() {
        if (!ValidationMode.NONE.equals((Object)this.xoUnit.getValidationMode())) {
            try {
                return Validation.buildDefaultValidatorFactory();
            }
            catch (ValidationException e) {
                LOGGER.debug("No JSR 303 Bean Validation provider available.", (Throwable)e);
            }
        }
        return null;
    }

    public XOManager createXOManager() {
        DatastoreSession datastoreSession = this.datastore.createSession();
        SessionContext sessionContext = new SessionContext(this.metadataProvider, this.pluginRepositoryManager, datastoreSession, this.validatorFactory, this.xoUnit, this.classLoader);
        XOManagerImpl xoManager = new XOManagerImpl(sessionContext);
        return (XOManager)sessionContext.getInterceptorFactory().addInterceptor(xoManager, new Class[]{XOManager.class});
    }

    public void close() {
        this.fireOnBeforeClose();
        this.datastore.close();
        this.fireOnAfterClose();
    }

    public XOUnit getXOUnit() {
        return this.xoUnit;
    }

    public <DS> DS getDatastore(Class<DS> datastoreType) {
        return datastoreType.cast(this.datastore);
    }

    public PluginRepositoryManager getPluginRepositoryManager() {
        return this.pluginRepositoryManager;
    }

    public MetadataProvider<EntityMetadata, EntityDiscriminator, RelationMetadata, RelationDiscriminator> getMetadataProvider() {
        return this.metadataProvider;
    }

    public void addCloseListener(CloseListener listener) {
        this.closeSupport.addCloseListener(listener);
    }

    public void removeCloseListener(CloseListener listener) {
        this.closeSupport.removeCloseListener(listener);
    }

    private void fireOnBeforeClose() {
        this.closeSupport.fireOnBeforeClose();
    }

    private void fireOnAfterClose() {
        this.closeSupport.fireOnAfterClose();
    }
}

