/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl.metadata;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.api.bootstrap.XOUnit;
import com.buschmais.xo.api.metadata.type.CompositeTypeMetadata;
import com.buschmais.xo.api.metadata.type.DatastoreEntityMetadata;
import com.buschmais.xo.api.metadata.type.EntityTypeMetadata;
import com.buschmais.xo.api.metadata.type.TypeMetadata;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityTypeMetadataResolver<EntityMetadata extends DatastoreEntityMetadata<Discriminator>, Discriminator> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityTypeMetadataResolver.class);
    private final Map<EntityTypeMetadata<EntityMetadata>, Set<Discriminator>> aggregatedDiscriminators = new HashMap<EntityTypeMetadata<EntityMetadata>, Set<Discriminator>>();
    private final Map<Discriminator, Set<EntityTypeMetadata<EntityMetadata>>> typeMetadataByDiscriminator = new HashMap<Discriminator, Set<EntityTypeMetadata<EntityMetadata>>>();
    private final Map<EntityTypeMetadata<EntityMetadata>, Set<EntityTypeMetadata<EntityMetadata>>> aggregatedSuperTypes = new HashMap<EntityTypeMetadata<EntityMetadata>, Set<EntityTypeMetadata<EntityMetadata>>>();
    private final Map<EntityTypeMetadata<EntityMetadata>, Set<EntityTypeMetadata<EntityMetadata>>> aggregatedSubTypes = new HashMap<EntityTypeMetadata<EntityMetadata>, Set<EntityTypeMetadata<EntityMetadata>>>();
    private final Map<Set<Discriminator>, CompositeTypeMetadata<EntityTypeMetadata<EntityMetadata>>> cache = new ConcurrentHashMap<Set<Discriminator>, CompositeTypeMetadata<EntityTypeMetadata<EntityMetadata>>>();

    public EntityTypeMetadataResolver(Map<Class<?>, TypeMetadata> metadataByType, XOUnit.MappingConfiguration mappingConfiguration) {
        Set<Discriminator> discriminators;
        LOGGER.debug("Type metadata = '{}'", metadataByType);
        for (TypeMetadata typeMetadata : metadataByType.values()) {
            if (!(typeMetadata instanceof EntityTypeMetadata)) continue;
            EntityTypeMetadata entityTypeMetadata = (EntityTypeMetadata)typeMetadata;
            this.aggregateSuperTypes(entityTypeMetadata);
        }
        HashMap<Set<Discriminator>, HashSet<EntityTypeMetadata>> entityMetadataByDiscriminators = new HashMap<Set<Discriminator>, HashSet<EntityTypeMetadata>>();
        for (TypeMetadata typeMetadata : metadataByType.values()) {
            if (!(typeMetadata instanceof EntityTypeMetadata)) continue;
            EntityTypeMetadata entityTypeMetadata = (EntityTypeMetadata)typeMetadata;
            discriminators = this.getAggregatedDiscriminators(entityTypeMetadata);
            HashSet<EntityTypeMetadata> typeMetadataOfDiscriminators = (HashSet<EntityTypeMetadata>)entityMetadataByDiscriminators.get(discriminators);
            if (typeMetadataOfDiscriminators == null) {
                typeMetadataOfDiscriminators = new HashSet<EntityTypeMetadata>();
                entityMetadataByDiscriminators.put(discriminators, typeMetadataOfDiscriminators);
            }
            typeMetadataOfDiscriminators.add(entityTypeMetadata);
            LOGGER.debug("Aggregated discriminators of '{}' = '{}'", (Object)typeMetadata, discriminators);
        }
        for (TypeMetadata typeMetadata : metadataByType.values()) {
            if (!(typeMetadata instanceof EntityTypeMetadata)) continue;
            EntityTypeMetadata metadata = (EntityTypeMetadata)typeMetadata;
            discriminators = this.getAggregatedDiscriminators(metadata);
            for (Discriminator discriminator : discriminators) {
                Set<EntityTypeMetadata<EntityMetadata>> entityTypeMetadata = this.typeMetadataByDiscriminator.get(discriminator);
                if (entityTypeMetadata == null) {
                    entityTypeMetadata = new HashSet<EntityTypeMetadata<EntityMetadata>>();
                    this.typeMetadataByDiscriminator.put(discriminator, entityTypeMetadata);
                }
                entityTypeMetadata.add(metadata);
            }
        }
        LOGGER.debug("Type metadata by discriminators: '{}'", this.typeMetadataByDiscriminator);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry entry : entityMetadataByDiscriminators.entrySet()) {
            if (((Set)entry.getValue()).size() <= 1) continue;
            String message = String.format("%s use the same set of discriminators %s.", entry.getValue(), entry.getKey());
            arrayList.add(message);
        }
        if (!arrayList.isEmpty() && mappingConfiguration.isStrictValidation()) {
            throw new XOException("Mapping problems detected: " + arrayList);
        }
        for (String message : arrayList) {
            LOGGER.warn(message);
        }
    }

    private Set<EntityTypeMetadata<EntityMetadata>> aggregateSuperTypes(EntityTypeMetadata<EntityMetadata> entityTypeMetadata) {
        Set<EntityTypeMetadata<EntityMetadata>> superTypes = this.aggregatedSuperTypes.get(entityTypeMetadata);
        if (superTypes == null) {
            superTypes = new HashSet<EntityTypeMetadata<EntityMetadata>>();
            for (TypeMetadata metadata : entityTypeMetadata.getSuperTypes()) {
                if (!(metadata instanceof EntityTypeMetadata)) continue;
                EntityTypeMetadata superTypeMetadata = (EntityTypeMetadata)metadata;
                superTypes.add(superTypeMetadata);
                this.addSubType(superTypeMetadata, entityTypeMetadata);
                superTypes.addAll(this.aggregateSuperTypes(superTypeMetadata));
                for (EntityTypeMetadata<EntityMetadata> superType : superTypes) {
                    this.addSubType(superType, entityTypeMetadata);
                }
            }
            this.aggregatedSuperTypes.put(entityTypeMetadata, superTypes);
        }
        return superTypes;
    }

    private void addSubType(EntityTypeMetadata<EntityMetadata> superType, EntityTypeMetadata<EntityMetadata> subType) {
        Set subTypes = this.aggregatedSubTypes.computeIfAbsent(superType, k -> new HashSet());
        subTypes.add(subType);
    }

    private Set<Discriminator> getAggregatedDiscriminators(EntityTypeMetadata<EntityMetadata> typeMetadata) {
        return this.aggregatedDiscriminators.computeIfAbsent(typeMetadata, k -> {
            HashSet<Object> discriminators = new HashSet<Object>();
            Object discriminator = ((DatastoreEntityMetadata)typeMetadata.getDatastoreMetadata()).getDiscriminator();
            if (discriminator != null) {
                discriminators.add(discriminator);
            }
            for (EntityTypeMetadata<EntityMetadata> superTypeMetadata : this.aggregatedSuperTypes.get(typeMetadata)) {
                discriminator = ((DatastoreEntityMetadata)superTypeMetadata.getDatastoreMetadata()).getDiscriminator();
                if (discriminator == null) continue;
                discriminators.add(discriminator);
            }
            return discriminators;
        });
    }

    public CompositeTypeMetadata<EntityTypeMetadata<EntityMetadata>> getDynamicType(Set<Discriminator> discriminators) {
        return this.cache.computeIfAbsent((Set<Discriminator>)ImmutableSet.builderWithExpectedSize((int)discriminators.size()).addAll(discriminators).build(), (Function<Set<Discriminator>, CompositeTypeMetadata<EntityTypeMetadata<EntityMetadata>>>)((Function<Set, CompositeTypeMetadata>)key -> {
            LOGGER.debug("Cache miss for discriminators {}.", key);
            HashSet<EntityTypeMetadata<EntityMetadata>> metadata = new HashSet<EntityTypeMetadata<EntityMetadata>>();
            for (Object discriminator : key) {
                Set<EntityTypeMetadata<EntityMetadata>> candidates = this.typeMetadataByDiscriminator.get(discriminator);
                if (candidates == null) continue;
                for (EntityTypeMetadata<EntityMetadata> candidate : candidates) {
                    Set<EntityTypeMetadata<EntityMetadata>> candidateSubTypes = this.aggregatedSubTypes.get(candidate);
                    if (candidateSubTypes != null && this.containsAny(metadata, candidateSubTypes)) continue;
                    Set<Discriminator> entityDiscriminators = this.aggregatedDiscriminators.get(candidate);
                    if (key.size() < entityDiscriminators.size() || !key.containsAll(entityDiscriminators)) continue;
                    metadata.add(candidate);
                    metadata.removeAll((Collection)this.aggregatedSuperTypes.get(candidate));
                }
            }
            return new CompositeTypeMetadata(metadata);
        }));
    }

    public <T> boolean containsAny(Set<T> set, Collection<T> other) {
        for (T t : other) {
            if (!set.contains(t)) continue;
            return true;
        }
        return false;
    }

    public Set<Discriminator> getDiscriminators(EntityTypeMetadata<EntityMetadata> entityTypeMetadata) {
        Set<Discriminator> discriminators = this.aggregatedDiscriminators.get(entityTypeMetadata);
        return discriminators != null ? discriminators : Collections.emptySet();
    }
}

