/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl.proxy.collection;

import com.buschmais.xo.api.metadata.method.AbstractRelationPropertyMethodMetadata;
import com.buschmais.xo.api.metadata.method.EntityCollectionPropertyMethodMetadata;
import com.buschmais.xo.impl.AbstractInstanceManager;
import com.buschmais.xo.impl.SessionContext;
import com.buschmais.xo.impl.proxy.collection.AbstractCollectionProxy;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class EntityCollectionProxy<Instance, Entity, Relation>
extends AbstractCollectionProxy<Instance, Entity, Relation, EntityCollectionPropertyMethodMetadata<?>>
implements Collection<Instance> {
    public EntityCollectionProxy(SessionContext<?, Entity, ?, ?, ?, Relation, ?, ?, ?> sessionContext, Entity entity, EntityCollectionPropertyMethodMetadata<?> metadata) {
        super(sessionContext, entity, metadata);
    }

    @Override
    public Iterator<Instance> iterator() {
        final SessionContext sessionContext = this.getSessionContext();
        final EntityCollectionPropertyMethodMetadata metadata = (EntityCollectionPropertyMethodMetadata)this.getMetadata();
        final Iterator iterator = sessionContext.getEntityPropertyManager().getEntityCollection(this.getEntity(), metadata);
        return (Iterator)sessionContext.getInterceptorFactory().addInterceptor((Object)new Iterator<Instance>(){
            private Instance instance = null;

            @Override
            public boolean hasNext() {
                while (!this.isInstance() && iterator.hasNext()) {
                    this.instance = sessionContext.getEntityInstanceManager().readInstance(iterator.next());
                }
                return this.isInstance();
            }

            private boolean isInstance() {
                return this.instance != null && metadata.getElementType().isAssignableFrom(this.instance.getClass());
            }

            @Override
            public Instance next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object next = this.instance;
                this.instance = null;
                return next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove not supported");
            }
        }, new Class[]{Iterator.class});
    }

    @Override
    public boolean add(Instance instance) {
        this.getSessionContext().getEntityPropertyManager().createEntityReference(this.getEntity(), (AbstractRelationPropertyMethodMetadata<?>)this.getMetadata(), instance);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        SessionContext sessionContext = this.getSessionContext();
        AbstractInstanceManager instanceManager = sessionContext.getEntityInstanceManager();
        if (instanceManager.isInstance(o)) {
            return sessionContext.getEntityPropertyManager().removeEntityReference(this.getEntity(), (EntityCollectionPropertyMethodMetadata)this.getMetadata(), o);
        }
        return false;
    }
}

