/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl.proxy.entity.property;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.api.metadata.method.AbstractRelationPropertyMethodMetadata;
import com.buschmais.xo.api.metadata.reflection.PropertyMethod;
import com.buschmais.xo.impl.AbstractPropertyManager;
import com.buschmais.xo.impl.SessionContext;
import com.buschmais.xo.impl.proxy.collection.AbstractCollectionProxy;
import com.buschmais.xo.impl.proxy.collection.ListProxy;
import com.buschmais.xo.impl.proxy.collection.SetProxy;
import com.buschmais.xo.impl.proxy.common.property.AbstractPropertyMethod;
import com.buschmais.xo.impl.proxy.entity.property.CollectionPropertyType;
import java.util.AbstractCollection;

public abstract class AbstractCollectionPropertyGetMethod<DatastoreType, Entity, Relation, PropertyManager extends AbstractPropertyManager<DatastoreType>, M extends AbstractRelationPropertyMethodMetadata<?>>
extends AbstractPropertyMethod<DatastoreType, PropertyManager, M> {
    private final SessionContext<?, Entity, ?, ?, ?, Relation, ?, ?, ?> sessionContext;
    private CollectionPropertyType collectionPropertyType;

    public AbstractCollectionPropertyGetMethod(SessionContext<?, Entity, ?, ?, ?, Relation, ?, ?, ?> sessionContext, PropertyManager propertyManager, M metadata) {
        super(propertyManager, metadata);
        this.sessionContext = sessionContext;
        this.collectionPropertyType = CollectionPropertyType.getCollectionPropertyType(((PropertyMethod)metadata.getAnnotatedMethod()).getType());
    }

    public Object invoke(DatastoreType entity, Object instance, Object[] args) {
        AbstractCollection collection;
        AbstractCollectionProxy<?, ?, ?, ?> collectionProxy = this.createCollectionProxy(entity, this.sessionContext);
        switch (this.collectionPropertyType) {
            case LIST: {
                collection = new ListProxy(collectionProxy);
                break;
            }
            case SET: {
                collection = new SetProxy(collectionProxy);
                break;
            }
            case COLLECTION: {
                collection = collectionProxy;
                break;
            }
            default: {
                throw new XOException("Unsupported collection type " + (Object)((Object)this.collectionPropertyType));
            }
        }
        return this.sessionContext.getInterceptorFactory().addInterceptor(collection, new Class[]{this.collectionPropertyType.getCollectionType()});
    }

    protected abstract AbstractCollectionProxy<?, ?, ?, ?> createCollectionProxy(DatastoreType var1, SessionContext<?, Entity, ?, ?, ?, Relation, ?, ?, ?> var2);
}

