/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl.proxy.common.resultof;

import com.buschmais.xo.api.Query;
import com.buschmais.xo.api.annotation.ResultOf;
import com.buschmais.xo.api.metadata.method.ResultOfMethodMetadata;
import com.buschmais.xo.api.proxy.ProxyMethod;
import com.buschmais.xo.impl.SessionContext;
import com.buschmais.xo.impl.converter.ValueConverter;
import com.buschmais.xo.impl.query.XOQueryImpl;
import java.util.List;

public abstract class AbstractResultOfMethod<DatastoreType, Entity, Relation>
implements ProxyMethod<DatastoreType> {
    private final SessionContext<?, Entity, ?, ?, ?, Relation, ?, ?, ?> sessionContext;
    private final ResultOfMethodMetadata<?> resultOfMethodMetadata;

    public AbstractResultOfMethod(SessionContext<?, Entity, ?, ?, ?, Relation, ?, ?, ?> sessionContext, ResultOfMethodMetadata<?> resultOfMethodMetadata) {
        this.sessionContext = sessionContext;
        this.resultOfMethodMetadata = resultOfMethodMetadata;
    }

    public Object invoke(DatastoreType datastoreType, Object instance, Object[] args) {
        Class returnType = this.resultOfMethodMetadata.getReturnType();
        XOQueryImpl query = new XOQueryImpl(this.sessionContext, this.resultOfMethodMetadata.getQuery(), returnType);
        Object thisInstance = this.getThisInstance(datastoreType, this.sessionContext);
        if (thisInstance != null) {
            String usingThisAs = this.resultOfMethodMetadata.getUsingThisAs();
            query.withParameter(usingThisAs, thisInstance);
        }
        List parameters = this.resultOfMethodMetadata.getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            query.withParameter(((ResultOf.Parameter)parameters.get(i)).value(), args[i]);
        }
        Query.Result result = query.execute();
        if (Void.TYPE.equals(returnType)) {
            result.close();
            return null;
        }
        if (this.resultOfMethodMetadata.isSingleResult()) {
            if (result.hasResult()) {
                return ValueConverter.convert(result.getSingleResult(), returnType);
            }
            return null;
        }
        return result;
    }

    protected abstract Object getThisInstance(DatastoreType var1, SessionContext<?, Entity, ?, ?, ?, Relation, ?, ?, ?> var2);
}

